/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ldaptive.AbstractFreezable;
import org.ldaptive.LdapException;
import org.ldaptive.ResultCode;
import org.ldaptive.auth.AuthenticationCriteria;
import org.ldaptive.auth.AuthenticationHandler;
import org.ldaptive.auth.AuthenticationHandlerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AggregateAuthenticationHandler
extends AbstractFreezable
implements AuthenticationHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, AuthenticationHandler> authenticationHandlers = new HashMap<String, AuthenticationHandler>();

    public AggregateAuthenticationHandler() {
    }

    public AggregateAuthenticationHandler(Map<String, AuthenticationHandler> handlers) {
        this.setAuthenticationHandlers(handlers);
    }

    @Override
    public void freeze() {
        super.freeze();
        AggregateAuthenticationHandler.freeze(this.authenticationHandlers);
    }

    public Map<String, AuthenticationHandler> getAuthenticationHandlers() {
        return Collections.unmodifiableMap(this.authenticationHandlers);
    }

    public void setAuthenticationHandlers(Map<String, AuthenticationHandler> handlers) {
        this.assertMutable();
        this.logger.trace("setting authenticationHandlers: {}", handlers);
        this.authenticationHandlers.putAll(handlers);
    }

    public void addAuthenticationHandler(String label, AuthenticationHandler handler) {
        this.assertMutable();
        this.logger.trace("adding authenticationHandler: {}:{}", (Object)label, (Object)handler);
        this.authenticationHandlers.put(label, handler);
    }

    @Override
    public AuthenticationHandlerResponse authenticate(AuthenticationCriteria criteria) throws LdapException {
        String[] labeledDn = criteria.getDn().split(":", 2);
        AuthenticationHandler ah = this.authenticationHandlers.get(labeledDn[0]);
        if (ah == null) {
            throw new LdapException(ResultCode.PARAM_ERROR, "Could not find authentication handler for label: " + labeledDn[0]);
        }
        return ah.authenticate(new AuthenticationCriteria(labeledDn[1], criteria.getAuthenticationRequest()));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final AggregateAuthenticationHandler object = new AggregateAuthenticationHandler();

        private Builder() {
        }

        public Builder freeze() {
            this.object.freeze();
            return this;
        }

        public Builder handler(String label, AuthenticationHandler handler) {
            this.object.addAuthenticationHandler(label, handler);
            return this;
        }

        public AggregateAuthenticationHandler build() {
            return this.object;
        }
    }
}

