/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.ad.handler;

import org.ldaptive.LdapEntry;
import org.ldaptive.LdapUtils;
import org.ldaptive.ad.GlobalIdentifier;
import org.ldaptive.ad.handler.AbstractBinaryAttributeHandler;
import org.ldaptive.handler.LdapEntryHandler;

public class ObjectGuidHandler
extends AbstractBinaryAttributeHandler<LdapEntry>
implements LdapEntryHandler {
    private static final int HASH_CODE_SEED = 1823;
    private static final String ATTRIBUTE_NAME = "objectGUID";
    private boolean withBrackets = true;

    public ObjectGuidHandler() {
        this.setAttributeName(ATTRIBUTE_NAME);
    }

    public ObjectGuidHandler(boolean brackets) {
        this.setAttributeName(ATTRIBUTE_NAME);
        this.setWithBrackets(brackets);
    }

    public ObjectGuidHandler(String attrName) {
        this.setAttributeName(attrName);
    }

    public ObjectGuidHandler(String attrName, boolean brackets) {
        this.setAttributeName(attrName);
        this.setWithBrackets(brackets);
    }

    public boolean getWithBrackets() {
        return this.withBrackets;
    }

    public void setWithBrackets(boolean brackets) {
        this.assertMutable();
        this.withBrackets = brackets;
    }

    @Override
    public LdapEntry apply(LdapEntry entry) {
        this.handleEntry(entry);
        return entry;
    }

    @Override
    protected String convertValue(byte[] value) {
        return GlobalIdentifier.toString(value, this.withBrackets);
    }

    public ObjectGuidHandler newInstance() {
        ObjectGuidHandler handler = new ObjectGuidHandler();
        handler.setAttributeName(this.getAttributeName());
        handler.setWithBrackets(this.withBrackets);
        return handler;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ObjectGuidHandler && super.equals(o)) {
            ObjectGuidHandler v = (ObjectGuidHandler)o;
            return LdapUtils.areEqual(this.withBrackets, v.withBrackets);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return LdapUtils.computeHashCode(1823, this.getAttributeName(), this.withBrackets);
    }
}

