/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.workflow.java;

import org.apache.syncope.common.lib.request.AnyObjectCR;
import org.apache.syncope.common.lib.request.AnyObjectUR;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.data.AnyObjectDataBinder;
import org.apache.syncope.core.provisioning.api.event.EntityLifecycleEvent;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.workflow.java.AbstractAnyObjectWorkflowAdapter;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class DefaultAnyObjectWorkflowAdapter
extends AbstractAnyObjectWorkflowAdapter {
    public DefaultAnyObjectWorkflowAdapter(AnyObjectDataBinder dataBinder, AnyObjectDAO anyObjectDAO, GroupDAO groupDAO, EntityFactory entityFactory, ApplicationEventPublisher publisher) {
        super(dataBinder, anyObjectDAO, groupDAO, entityFactory, publisher);
    }

    @Override
    protected WorkflowResult<String> doCreate(AnyObjectCR anyObjectCR, String creator, String context) {
        AnyObject anyObject = (AnyObject)this.entityFactory.newEntity(AnyObject.class);
        this.dataBinder.create(anyObject, anyObjectCR);
        this.metadata((Any)anyObject, creator, context);
        anyObject = (AnyObject)this.anyObjectDAO.save((Entity)anyObject);
        this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.CREATE, (Entity)anyObject, AuthContextUtils.getDomain()));
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.set(ResourceOperation.CREATE, this.anyObjectDAO.findAllResourceKeys(anyObject.getKey()));
        return new WorkflowResult((Object)anyObject.getKey(), propByRes, "create");
    }

    @Override
    protected WorkflowResult<AnyObjectUR> doUpdate(AnyObject anyObject, AnyObjectUR anyObjectUR, String updater, String context) {
        PropagationByResource propByRes = this.dataBinder.update(anyObject, anyObjectUR);
        this.metadata((Any)anyObject, updater, context);
        AnyObject updated = (AnyObject)this.anyObjectDAO.save((Entity)anyObject);
        this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Entity)updated, AuthContextUtils.getDomain()));
        return new WorkflowResult((Object)anyObjectUR, propByRes, "update");
    }

    @Override
    protected void doDelete(AnyObject anyObject, String eraser, String context) {
        this.anyObjectDAO.delete((Entity)anyObject);
        this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.DELETE, (Entity)anyObject, AuthContextUtils.getDomain()));
    }
}

