/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.pipeline;

import java.util.Collection;
import java.util.Collections;
import org.flowable.eventregistry.api.EventRegistryEvent;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.api.FlowableEventInfo;
import org.flowable.eventregistry.api.InboundEvent;
import org.flowable.eventregistry.api.InboundEventDeserializer;
import org.flowable.eventregistry.api.InboundEventFilter;
import org.flowable.eventregistry.api.InboundEventKeyDetector;
import org.flowable.eventregistry.api.InboundEventPayloadExtractor;
import org.flowable.eventregistry.api.InboundEventProcessingPipeline;
import org.flowable.eventregistry.api.InboundEventTenantDetector;
import org.flowable.eventregistry.api.InboundEventTransformer;
import org.flowable.eventregistry.api.runtime.EventInstance;
import org.flowable.eventregistry.api.runtime.EventPayloadInstance;
import org.flowable.eventregistry.impl.FlowableEventInfoImpl;
import org.flowable.eventregistry.impl.runtime.EventInstanceImpl;
import org.flowable.eventregistry.model.EventModel;
import org.flowable.eventregistry.model.InboundChannelModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInboundEventProcessingPipeline<T>
implements InboundEventProcessingPipeline {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected EventRepositoryService eventRepositoryService;
    protected InboundEventDeserializer<T> inboundEventDeserializer;
    protected InboundEventFilter<T> inboundEventFilter;
    protected InboundEventKeyDetector<T> inboundEventKeyDetector;
    protected InboundEventTenantDetector<T> inboundEventTenantDetector;
    protected InboundEventPayloadExtractor<T> inboundEventPayloadExtractor;
    protected InboundEventTransformer inboundEventTransformer;

    public DefaultInboundEventProcessingPipeline(EventRepositoryService eventRepositoryService, InboundEventDeserializer<T> inboundEventDeserializer, InboundEventFilter<T> inboundEventFilter, InboundEventKeyDetector<T> inboundEventKeyDetector, InboundEventTenantDetector<T> inboundEventTenantDetector, InboundEventPayloadExtractor<T> inboundEventPayloadExtractor, InboundEventTransformer inboundEventTransformer) {
        this.eventRepositoryService = eventRepositoryService;
        this.inboundEventDeserializer = inboundEventDeserializer;
        this.inboundEventFilter = inboundEventFilter;
        this.inboundEventKeyDetector = inboundEventKeyDetector;
        this.inboundEventTenantDetector = inboundEventTenantDetector;
        this.inboundEventPayloadExtractor = inboundEventPayloadExtractor;
        this.inboundEventTransformer = inboundEventTransformer;
    }

    public Collection<EventRegistryEvent> run(InboundChannelModel inboundChannel, InboundEvent inboundEvent) {
        boolean debugLoggingEnabled = this.logger.isDebugEnabled();
        if (debugLoggingEnabled) {
            this.logger.debug("Running inbound pipeline for inbound {} channel {}. Inbound event: {}", new Object[]{inboundChannel.getChannelType(), inboundChannel.getKey(), inboundEvent});
        }
        T deserializedBody = this.deserialize(inboundEvent.getBody());
        FlowableEventInfoImpl<T> event = new FlowableEventInfoImpl<T>(inboundEvent, deserializedBody, inboundChannel);
        String eventKey = this.detectEventDefinitionKey(event);
        if (this.inboundEventFilter != null && !this.inboundEventFilter.retain(eventKey, event)) {
            if (debugLoggingEnabled) {
                this.logger.debug("Inbound event {} on inbound {} channel {} was filtered out.", new Object[]{inboundEvent, inboundChannel.getChannelType(), inboundChannel.getKey()});
            }
            return Collections.emptyList();
        }
        boolean multiTenant = false;
        String tenantId = "";
        if (this.inboundEventTenantDetector != null) {
            tenantId = this.inboundEventTenantDetector.detectTenantId(event);
            multiTenant = true;
        }
        if (debugLoggingEnabled) {
            this.logger.debug("Detected event {} and tenant {} for inbound {} channel {}. Inbound event: {}", new Object[]{eventKey, tenantId, inboundChannel.getChannelType(), inboundChannel.getKey(), inboundEvent});
        }
        EventModel eventModel = multiTenant ? this.eventRepositoryService.getEventModelByKey(eventKey, tenantId) : this.eventRepositoryService.getEventModelByKey(eventKey);
        EventInstanceImpl eventInstance = new EventInstanceImpl(eventModel.getKey(), this.extractPayload(eventModel, event), tenantId);
        if (debugLoggingEnabled) {
            this.logger.debug("Transforming {} for inbound {} channel {}. Inbound event: {}", new Object[]{eventInstance, inboundChannel.getChannelType(), inboundChannel.getKey(), inboundEvent});
        }
        Collection<EventRegistryEvent> registryEvents = this.transform(eventInstance);
        if (debugLoggingEnabled) {
            this.logger.debug("Transformed {} to {} for inbound {} channel {}. Inbound event: {}", new Object[]{eventInstance, registryEvents, inboundChannel.getChannelType(), inboundChannel.getKey(), inboundEvent});
        }
        return registryEvents;
    }

    public T deserialize(Object rawEvent) {
        return (T)this.inboundEventDeserializer.deserialize(rawEvent);
    }

    public String detectEventDefinitionKey(FlowableEventInfo<T> event) {
        return this.inboundEventKeyDetector.detectEventDefinitionKey(event);
    }

    public Collection<EventPayloadInstance> extractPayload(EventModel eventDefinition, FlowableEventInfo<T> event) {
        return this.inboundEventPayloadExtractor.extractPayload(eventDefinition, event);
    }

    public Collection<EventRegistryEvent> transform(EventInstance eventInstance) {
        return this.inboundEventTransformer.transform(eventInstance);
    }

    public InboundEventDeserializer<T> getInboundEventDeserializer() {
        return this.inboundEventDeserializer;
    }

    public void setInboundEventDeserializer(InboundEventDeserializer<T> inboundEventDeserializer) {
        this.inboundEventDeserializer = inboundEventDeserializer;
    }

    public InboundEventKeyDetector<T> getInboundEventKeyDetector() {
        return this.inboundEventKeyDetector;
    }

    public void setInboundEventKeyDetector(InboundEventKeyDetector<T> inboundEventKeyDetector) {
        this.inboundEventKeyDetector = inboundEventKeyDetector;
    }

    public InboundEventTenantDetector<T> getInboundEventTenantDetector() {
        return this.inboundEventTenantDetector;
    }

    public void setInboundEventTenantDetector(InboundEventTenantDetector<T> inboundEventTenantDetector) {
        this.inboundEventTenantDetector = inboundEventTenantDetector;
    }

    public InboundEventPayloadExtractor<T> getInboundEventPayloadExtractor() {
        return this.inboundEventPayloadExtractor;
    }

    public void setInboundEventPayloadExtractor(InboundEventPayloadExtractor<T> inboundEventPayloadExtractor) {
        this.inboundEventPayloadExtractor = inboundEventPayloadExtractor;
    }

    public InboundEventTransformer getInboundEventTransformer() {
        return this.inboundEventTransformer;
    }

    public void setInboundEventTransformer(InboundEventTransformer inboundEventTransformer) {
        this.inboundEventTransformer = inboundEventTransformer;
    }
}

