/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.nio.charset.StandardCharsets;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.AbstractJackson2HttpMessageConverter;

public class CasYamlHttpMessageConverter
extends AbstractJackson2HttpMessageConverter {
    public static final MediaType MEDIA_TYPE_CAS_YAML = new MediaType("application", "vnd.cas.services+yaml");
    public static final MediaType MEDIA_TYPE_YAML = MediaType.parseMediaType((String)"application/yaml");
    public static final MediaType MEDIA_TYPE_YML = MediaType.parseMediaType((String)"application/yml");
    private static final ObjectMapper YAML_OBJECT_MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).jsonFactory((JsonFactory)new YAMLFactory()).build().toObjectMapper();

    public CasYamlHttpMessageConverter() {
        super(YAML_OBJECT_MAPPER, new MediaType[]{MEDIA_TYPE_CAS_YAML, MEDIA_TYPE_YAML, MEDIA_TYPE_YML});
        this.setPrettyPrint(true);
        this.setDefaultCharset(StandardCharsets.UTF_8);
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return mediaType != null && this.getSupportedMediaTypes().contains(mediaType);
    }
}

