/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.kafka.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Base64;
import java.util.Objects;
import org.identityconnectors.framework.common.objects.SyncToken;

public class SyncTokenDeserializer
extends JsonDeserializer<SyncToken> {
    public SyncToken deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        ObjectNode tree = (ObjectNode)jp.readValueAsTree();
        Object value = tree.has("value") ? (tree.has("type") ? this.deserialize(tree.get("value"), tree.get("type")) : this.deserialize(tree.get("value"))) : null;
        return new SyncToken(Objects.requireNonNull(value));
    }

    private Object deserialize(JsonNode value, JsonNode type) {
        if (Boolean.class.getSimpleName().equals(type.asText())) {
            return value.asBoolean();
        }
        if (Double.class.getSimpleName().equals(type.asText())) {
            return value.asDouble();
        }
        if (Long.class.getSimpleName().equals(type.asText())) {
            return value.asLong();
        }
        if (Integer.class.getSimpleName().equals(type.asText())) {
            return value.asInt();
        }
        return value.asText();
    }

    private Object deserialize(JsonNode value) {
        if (value.isBoolean()) {
            return value.asBoolean();
        }
        if (value.isDouble()) {
            return value.asDouble();
        }
        if (value.isLong()) {
            return value.asLong();
        }
        if (value.isInt()) {
            return value.asInt();
        }
        try {
            return Base64.getDecoder().decode(value.asText());
        }
        catch (RuntimeException e) {
            return value.asText();
        }
    }
}

