/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.scim.common.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.tirasa.connid.bundles.scim.common.SCIMProvider;
import net.tirasa.connid.bundles.scim.common.dto.BaseResourceReference;
import net.tirasa.connid.bundles.scim.common.dto.SCIMBaseAttribute;
import net.tirasa.connid.bundles.scim.common.dto.SCIMSchema;
import net.tirasa.connid.bundles.scim.common.dto.SCIMUser;
import net.tirasa.connid.bundles.scim.common.utils.SCIMAttributeUtils;
import net.tirasa.connid.bundles.scim.v11.dto.SCIMv11Attribute;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2Attribute;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;

public final class SCIMUtils {
    private static final Log LOG = Log.getLog(SCIMUtils.class);
    public static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);

    public static List<Field> getAllFieldsList(Class<?> cls) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        for (Class<?> currentClass = cls; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Field[] declaredFields = currentClass.getDeclaredFields();
            Collections.addAll(allFields, declaredFields);
        }
        return allFields;
    }

    public static void handleGeneralError(String message) {
        LOG.error("General error : {0}", new Object[]{message});
        throw new ConnectorException(message);
    }

    public static void handleGeneralError(String message, Exception ex) {
        LOG.error((Throwable)ex, message, new Object[0]);
        throw new ConnectorException(message, (Throwable)ex);
    }

    public static void wrapGeneralError(String message, Exception ex) {
        LOG.error((Throwable)ex, message, new Object[0]);
        throw ConnectorException.wrap((Throwable)ex);
    }

    public static boolean isEmptyObject(Object obj) {
        return obj == null || obj instanceof List && new ArrayList((List)obj).isEmpty() || obj instanceof String && StringUtil.isBlank((String)((String)String.class.cast(obj)));
    }

    public static <T extends SCIMBaseAttribute<T>> String cleanAttributesToGet(Set<String> attributesToGet, String customAttributesJSON, boolean useColon, Class<T> attrType) {
        return SCIMUtils.cleanAttributesToGet(attributesToGet, customAttributesJSON, attrType, true, useColon);
    }

    public static <T extends SCIMBaseAttribute<T>> String cleanAttributesToGet(Set<String> attributesToGet, String customAttributesJSON, Class<T> attrType, boolean addCustomAttrsToQueryParams, boolean useColon) {
        if (attributesToGet.isEmpty()) {
            return SCIMAttributeUtils.defaultAttributesToGet();
        }
        SCIMSchema customAttributesObj = StringUtil.isBlank((String)customAttributesJSON) ? null : (SCIMSchema)SCIMUtils.extractSCIMSchemas(customAttributesJSON, attrType).orElse(null);
        StringBuilder result = new StringBuilder();
        for (String attributeToGet : attributesToGet) {
            if (attributeToGet.contains("__") || attributeToGet.contains("meta.") || attributeToGet.toLowerCase().contains("password")) continue;
            if (attributeToGet.contains("name.")) {
                result.append("name").append(",");
                continue;
            }
            if (attributeToGet.contains("addresses.")) {
                result.append("addresses").append(",");
                continue;
            }
            if (attributeToGet.contains("phoneNumbers.")) {
                result.append("phoneNumbers").append(",");
                continue;
            }
            if (attributeToGet.contains("ims.")) {
                result.append("ims").append(",");
                continue;
            }
            if (attributeToGet.contains("emails.")) {
                result.append("emails").append(",");
                continue;
            }
            if (attributeToGet.contains("roles.")) {
                result.append("roles").append(",");
                continue;
            }
            if (attributeToGet.contains("groups.")) {
                result.append("groups").append(",");
                continue;
            }
            if (attributeToGet.contains("photos.")) {
                result.append("photos").append(",");
                continue;
            }
            if (attributeToGet.contains("x509Certificates.")) {
                result.append("x509Certificates").append(",");
                continue;
            }
            if (attributeToGet.contains("entitlements.")) {
                result.append("entitlements").append(",");
                continue;
            }
            if (attributeToGet.startsWith("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User")) {
                result.append("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User").append(attributeToGet.replace("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User", "")).append(",");
                continue;
            }
            if (customAttributesObj == null) {
                result.append(attributeToGet).append(",");
                continue;
            }
            if (SCIMUtils.isCustomAttribute(customAttributesObj, attributeToGet, useColon)) continue;
            result.append(attributeToGet).append(",");
        }
        if (customAttributesObj != null && addCustomAttrsToQueryParams) {
            for (SCIMBaseAttribute attribute : customAttributesObj.getAttributes()) {
                String attributeName;
                Object object = attribute instanceof SCIMv2Attribute ? ((SCIMv2Attribute)SCIMv2Attribute.class.cast(attribute)).getExtensionSchema() + (useColon ? ":" : ".") + attribute.getName() : (attributeName = attribute.getName());
                if (result.toString().contains(attributeName)) continue;
                result.append(attributeName).append(",");
            }
        }
        if (!result.toString().contains("userName,")) {
            result.append("userName").append(",");
        }
        if (!result.toString().contains("id,")) {
            result.append("id").append(",");
        }
        if (!result.toString().contains("name,")) {
            result.append("name").append(",");
        }
        return result.length() == 0 ? SCIMAttributeUtils.defaultAttributesToGet() : result.substring(0, result.length() - 1);
    }

    private static <T extends SCIMBaseAttribute<T>> boolean isCustomAttribute(SCIMSchema<T> customAttributes, String attribute, boolean useColon) {
        for (SCIMBaseAttribute customAttribute : customAttributes.getAttributes()) {
            String externalAttributeName = customAttribute instanceof SCIMv11Attribute ? ((SCIMv11Attribute)customAttribute).getSchema().concat(useColon ? ":" : ".").concat(customAttribute.getName()) : ((SCIMv2Attribute)customAttribute).getExtensionSchema().concat(useColon ? ":" : ".").concat(customAttribute.getName());
            if (!externalAttributeName.equals(attribute)) continue;
            return true;
        }
        return false;
    }

    public static <T extends SCIMBaseAttribute<T>> Optional<SCIMSchema<T>> extractSCIMSchemas(String json, Class<T> attrType) {
        if (StringUtil.isBlank((String)json)) {
            return Optional.empty();
        }
        try {
            SCIMSchema scimSchema = (SCIMSchema)MAPPER.readValue(json, MAPPER.getTypeFactory().constructParametricType(SCIMSchema.class, new Class[]{attrType}));
            if (SCIMv2Attribute.class.equals(attrType)) {
                scimSchema.getAttributes().forEach(attr -> ((SCIMv2Attribute)SCIMv2Attribute.class.cast(attr)).setExtensionSchema(scimSchema.getId()));
            }
            return scimSchema.getAttributes().isEmpty() ? Optional.empty() : Optional.of(scimSchema);
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex, "While parsing custom attributes JSON object, taken from connector configuration", new Object[0]);
            return Optional.empty();
        }
    }

    public static <UT extends SCIMUser<?, ?>> BaseResourceReference buildGroupMember(UT user, SCIMProvider scimProvider) {
        BaseResourceReference.Builder groupMemberBuilder = new BaseResourceReference.Builder();
        switch (scimProvider) {
            case WSO2: {
                groupMemberBuilder.value(user.getId()).display(user.getUserName());
                break;
            }
            default: {
                groupMemberBuilder.value(user.getId());
            }
        }
        return groupMemberBuilder.build();
    }

    private SCIMUtils() {
    }
}

