/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.attestation;

import com.yubico.internal.util.BinaryUtil;
import com.yubico.webauthn.data.ByteArray;
import java.security.cert.X509Certificate;
import java.util.Optional;
import lombok.Generated;

public final class CertificateUtil {
    public static final String ID_FIDO_GEN_CE_SERNUM = "1.3.6.1.4.1.45724.1.1.2";

    private static byte[] parseSerNum(byte[] bytes) {
        try {
            byte[] extensionValueContents = (byte[])BinaryUtil.parseDerOctetString((byte[])bytes, (int)0).result;
            byte[] sernumContents = (byte[])BinaryUtil.parseDerOctetString((byte[])extensionValueContents, (int)0).result;
            return sernumContents;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("X.509 extension 1.3.6.1.4.1.45724.1.1.2 (id-fido-gen-ce-sernum) is not valid.", e);
        }
    }

    public static Optional<ByteArray> parseFidoSernumExtension(X509Certificate cert) {
        return Optional.ofNullable(cert.getExtensionValue(ID_FIDO_GEN_CE_SERNUM)).map(CertificateUtil::parseSerNum).map(ByteArray::new);
    }

    @Generated
    private CertificateUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

