/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.fido.metadata;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yubico.fido.metadata.AAGUID;
import com.yubico.fido.metadata.CtapCertificationId;
import com.yubico.fido.metadata.CtapPinUvAuthProtocolVersion;
import com.yubico.fido.metadata.CtapVersion;
import com.yubico.fido.metadata.SupportedCtapOptions;
import com.yubico.webauthn.data.AuthenticatorTransport;
import com.yubico.webauthn.data.PublicKeyCredentialParameters;
import com.yubico.webauthn.extension.uvm.UserVerificationMethod;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

@JsonIgnoreProperties(value={"maxAuthenticatorConfigLength", "defaultCredProtect"})
@JsonDeserialize(builder=AuthenticatorGetInfoBuilder.class)
public final class AuthenticatorGetInfo {
    @NonNull
    private final Set<CtapVersion> versions;
    private final Set<String> extensions;
    private final AAGUID aaguid;
    private final SupportedCtapOptions options;
    private final Integer maxMsgSize;
    private final Set<CtapPinUvAuthProtocolVersion> pinUvAuthProtocols;
    private final Integer maxCredentialCountInList;
    private final Integer maxCredentialIdLength;
    private final Set<AuthenticatorTransport> transports;
    @JsonDeserialize(using=ListPublicKeyCredentialParametersIgnoringUnknownValuesDeserializer.class)
    private final List<PublicKeyCredentialParameters> algorithms;
    private final Integer maxSerializedLargeBlobArray;
    private final Boolean forcePINChange;
    private final Integer minPINLength;
    private final Integer firmwareVersion;
    private final Integer maxCredBlobLength;
    private final Integer maxRPIDsForSetMinPINLength;
    private final Integer preferredPlatformUvAttempts;
    @JsonDeserialize(using=SetFromIntJsonDeserializer.class)
    @JsonSerialize(contentUsing=IntFromSetJsonSerializer.class)
    private final Set<UserVerificationMethod> uvModality;
    private final Map<CtapCertificationId, Integer> certifications;
    private final Integer remainingDiscoverableCredentials;
    private final Set<Integer> vendorPrototypeConfigCommands;

    public Optional<Set<String>> getExtensions() {
        return Optional.ofNullable(this.extensions);
    }

    public Optional<AAGUID> getAaguid() {
        return Optional.ofNullable(this.aaguid);
    }

    public Optional<SupportedCtapOptions> getOptions() {
        return Optional.ofNullable(this.options);
    }

    public Optional<Integer> getMaxMsgSize() {
        return Optional.ofNullable(this.maxMsgSize);
    }

    public Optional<Set<CtapPinUvAuthProtocolVersion>> getPinUvAuthProtocols() {
        return Optional.ofNullable(this.pinUvAuthProtocols);
    }

    public Optional<Integer> getMaxCredentialCountInList() {
        return Optional.ofNullable(this.maxCredentialCountInList);
    }

    public Optional<Integer> getMaxCredentialIdLength() {
        return Optional.ofNullable(this.maxCredentialIdLength);
    }

    public Optional<Set<AuthenticatorTransport>> getTransports() {
        return Optional.ofNullable(this.transports);
    }

    public Optional<List<PublicKeyCredentialParameters>> getAlgorithms() {
        return Optional.ofNullable(this.algorithms);
    }

    public Optional<Integer> getMaxSerializedLargeBlobArray() {
        return Optional.ofNullable(this.maxSerializedLargeBlobArray);
    }

    public Optional<Boolean> getForcePINChange() {
        return Optional.ofNullable(this.forcePINChange);
    }

    public Optional<Integer> getMinPINLength() {
        return Optional.ofNullable(this.minPINLength);
    }

    public Optional<Integer> getFirmwareVersion() {
        return Optional.ofNullable(this.firmwareVersion);
    }

    public Optional<Integer> getMaxCredBlobLength() {
        return Optional.ofNullable(this.maxCredBlobLength);
    }

    public Optional<Integer> getMaxRPIDsForSetMinPINLength() {
        return Optional.ofNullable(this.maxRPIDsForSetMinPINLength);
    }

    public Optional<Integer> getPreferredPlatformUvAttempts() {
        return Optional.ofNullable(this.preferredPlatformUvAttempts);
    }

    public Optional<Set<UserVerificationMethod>> getUvModality() {
        return Optional.ofNullable(this.uvModality);
    }

    public Optional<Map<CtapCertificationId, Integer>> getCertifications() {
        return Optional.ofNullable(this.certifications);
    }

    public Optional<Integer> getRemainingDiscoverableCredentials() {
        return Optional.ofNullable(this.remainingDiscoverableCredentials);
    }

    public Optional<Set<Integer>> getVendorPrototypeConfigCommands() {
        return Optional.ofNullable(this.vendorPrototypeConfigCommands);
    }

    @Generated
    AuthenticatorGetInfo(@NonNull Set<CtapVersion> versions, Set<String> extensions, AAGUID aaguid, SupportedCtapOptions options, Integer maxMsgSize, Set<CtapPinUvAuthProtocolVersion> pinUvAuthProtocols, Integer maxCredentialCountInList, Integer maxCredentialIdLength, Set<AuthenticatorTransport> transports, List<PublicKeyCredentialParameters> algorithms, Integer maxSerializedLargeBlobArray, Boolean forcePINChange, Integer minPINLength, Integer firmwareVersion, Integer maxCredBlobLength, Integer maxRPIDsForSetMinPINLength, Integer preferredPlatformUvAttempts, Set<UserVerificationMethod> uvModality, Map<CtapCertificationId, Integer> certifications, Integer remainingDiscoverableCredentials, Set<Integer> vendorPrototypeConfigCommands) {
        if (versions == null) {
            throw new NullPointerException("versions is marked non-null but is null");
        }
        this.versions = versions;
        this.extensions = extensions;
        this.aaguid = aaguid;
        this.options = options;
        this.maxMsgSize = maxMsgSize;
        this.pinUvAuthProtocols = pinUvAuthProtocols;
        this.maxCredentialCountInList = maxCredentialCountInList;
        this.maxCredentialIdLength = maxCredentialIdLength;
        this.transports = transports;
        this.algorithms = algorithms;
        this.maxSerializedLargeBlobArray = maxSerializedLargeBlobArray;
        this.forcePINChange = forcePINChange;
        this.minPINLength = minPINLength;
        this.firmwareVersion = firmwareVersion;
        this.maxCredBlobLength = maxCredBlobLength;
        this.maxRPIDsForSetMinPINLength = maxRPIDsForSetMinPINLength;
        this.preferredPlatformUvAttempts = preferredPlatformUvAttempts;
        this.uvModality = uvModality;
        this.certifications = certifications;
        this.remainingDiscoverableCredentials = remainingDiscoverableCredentials;
        this.vendorPrototypeConfigCommands = vendorPrototypeConfigCommands;
    }

    @Generated
    public static AuthenticatorGetInfoBuilder builder() {
        return new AuthenticatorGetInfoBuilder();
    }

    @Generated
    public AuthenticatorGetInfoBuilder toBuilder() {
        return new AuthenticatorGetInfoBuilder().versions(this.versions).extensions(this.extensions).aaguid(this.aaguid).options(this.options).maxMsgSize(this.maxMsgSize).pinUvAuthProtocols(this.pinUvAuthProtocols).maxCredentialCountInList(this.maxCredentialCountInList).maxCredentialIdLength(this.maxCredentialIdLength).transports(this.transports).algorithms(this.algorithms).maxSerializedLargeBlobArray(this.maxSerializedLargeBlobArray).forcePINChange(this.forcePINChange).minPINLength(this.minPINLength).firmwareVersion(this.firmwareVersion).maxCredBlobLength(this.maxCredBlobLength).maxRPIDsForSetMinPINLength(this.maxRPIDsForSetMinPINLength).preferredPlatformUvAttempts(this.preferredPlatformUvAttempts).uvModality(this.uvModality).certifications(this.certifications).remainingDiscoverableCredentials(this.remainingDiscoverableCredentials).vendorPrototypeConfigCommands(this.vendorPrototypeConfigCommands);
    }

    @NonNull
    @Generated
    public Set<CtapVersion> getVersions() {
        return this.versions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticatorGetInfo)) {
            return false;
        }
        AuthenticatorGetInfo other = (AuthenticatorGetInfo)o;
        Optional<Integer> this$maxMsgSize = this.getMaxMsgSize();
        Optional<Integer> other$maxMsgSize = other.getMaxMsgSize();
        if (this$maxMsgSize == null ? other$maxMsgSize != null : !((Object)this$maxMsgSize).equals(other$maxMsgSize)) {
            return false;
        }
        Optional<Integer> this$maxCredentialCountInList = this.getMaxCredentialCountInList();
        Optional<Integer> other$maxCredentialCountInList = other.getMaxCredentialCountInList();
        if (this$maxCredentialCountInList == null ? other$maxCredentialCountInList != null : !((Object)this$maxCredentialCountInList).equals(other$maxCredentialCountInList)) {
            return false;
        }
        Optional<Integer> this$maxCredentialIdLength = this.getMaxCredentialIdLength();
        Optional<Integer> other$maxCredentialIdLength = other.getMaxCredentialIdLength();
        if (this$maxCredentialIdLength == null ? other$maxCredentialIdLength != null : !((Object)this$maxCredentialIdLength).equals(other$maxCredentialIdLength)) {
            return false;
        }
        Optional<Integer> this$maxSerializedLargeBlobArray = this.getMaxSerializedLargeBlobArray();
        Optional<Integer> other$maxSerializedLargeBlobArray = other.getMaxSerializedLargeBlobArray();
        if (this$maxSerializedLargeBlobArray == null ? other$maxSerializedLargeBlobArray != null : !((Object)this$maxSerializedLargeBlobArray).equals(other$maxSerializedLargeBlobArray)) {
            return false;
        }
        Optional<Boolean> this$forcePINChange = this.getForcePINChange();
        Optional<Boolean> other$forcePINChange = other.getForcePINChange();
        if (this$forcePINChange == null ? other$forcePINChange != null : !((Object)this$forcePINChange).equals(other$forcePINChange)) {
            return false;
        }
        Optional<Integer> this$minPINLength = this.getMinPINLength();
        Optional<Integer> other$minPINLength = other.getMinPINLength();
        if (this$minPINLength == null ? other$minPINLength != null : !((Object)this$minPINLength).equals(other$minPINLength)) {
            return false;
        }
        Optional<Integer> this$firmwareVersion = this.getFirmwareVersion();
        Optional<Integer> other$firmwareVersion = other.getFirmwareVersion();
        if (this$firmwareVersion == null ? other$firmwareVersion != null : !((Object)this$firmwareVersion).equals(other$firmwareVersion)) {
            return false;
        }
        Optional<Integer> this$maxCredBlobLength = this.getMaxCredBlobLength();
        Optional<Integer> other$maxCredBlobLength = other.getMaxCredBlobLength();
        if (this$maxCredBlobLength == null ? other$maxCredBlobLength != null : !((Object)this$maxCredBlobLength).equals(other$maxCredBlobLength)) {
            return false;
        }
        Optional<Integer> this$maxRPIDsForSetMinPINLength = this.getMaxRPIDsForSetMinPINLength();
        Optional<Integer> other$maxRPIDsForSetMinPINLength = other.getMaxRPIDsForSetMinPINLength();
        if (this$maxRPIDsForSetMinPINLength == null ? other$maxRPIDsForSetMinPINLength != null : !((Object)this$maxRPIDsForSetMinPINLength).equals(other$maxRPIDsForSetMinPINLength)) {
            return false;
        }
        Optional<Integer> this$preferredPlatformUvAttempts = this.getPreferredPlatformUvAttempts();
        Optional<Integer> other$preferredPlatformUvAttempts = other.getPreferredPlatformUvAttempts();
        if (this$preferredPlatformUvAttempts == null ? other$preferredPlatformUvAttempts != null : !((Object)this$preferredPlatformUvAttempts).equals(other$preferredPlatformUvAttempts)) {
            return false;
        }
        Optional<Integer> this$remainingDiscoverableCredentials = this.getRemainingDiscoverableCredentials();
        Optional<Integer> other$remainingDiscoverableCredentials = other.getRemainingDiscoverableCredentials();
        if (this$remainingDiscoverableCredentials == null ? other$remainingDiscoverableCredentials != null : !((Object)this$remainingDiscoverableCredentials).equals(other$remainingDiscoverableCredentials)) {
            return false;
        }
        Set<CtapVersion> this$versions = this.getVersions();
        Set<CtapVersion> other$versions = other.getVersions();
        if (this$versions == null ? other$versions != null : !((Object)this$versions).equals(other$versions)) {
            return false;
        }
        Optional<Set<String>> this$extensions = this.getExtensions();
        Optional<Set<String>> other$extensions = other.getExtensions();
        if (this$extensions == null ? other$extensions != null : !((Object)this$extensions).equals(other$extensions)) {
            return false;
        }
        Optional<AAGUID> this$aaguid = this.getAaguid();
        Optional<AAGUID> other$aaguid = other.getAaguid();
        if (this$aaguid == null ? other$aaguid != null : !((Object)this$aaguid).equals(other$aaguid)) {
            return false;
        }
        Optional<SupportedCtapOptions> this$options = this.getOptions();
        Optional<SupportedCtapOptions> other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        Optional<Set<CtapPinUvAuthProtocolVersion>> this$pinUvAuthProtocols = this.getPinUvAuthProtocols();
        Optional<Set<CtapPinUvAuthProtocolVersion>> other$pinUvAuthProtocols = other.getPinUvAuthProtocols();
        if (this$pinUvAuthProtocols == null ? other$pinUvAuthProtocols != null : !((Object)this$pinUvAuthProtocols).equals(other$pinUvAuthProtocols)) {
            return false;
        }
        Optional<Set<AuthenticatorTransport>> this$transports = this.getTransports();
        Optional<Set<AuthenticatorTransport>> other$transports = other.getTransports();
        if (this$transports == null ? other$transports != null : !((Object)this$transports).equals(other$transports)) {
            return false;
        }
        Optional<List<PublicKeyCredentialParameters>> this$algorithms = this.getAlgorithms();
        Optional<List<PublicKeyCredentialParameters>> other$algorithms = other.getAlgorithms();
        if (this$algorithms == null ? other$algorithms != null : !((Object)this$algorithms).equals(other$algorithms)) {
            return false;
        }
        Optional<Set<UserVerificationMethod>> this$uvModality = this.getUvModality();
        Optional<Set<UserVerificationMethod>> other$uvModality = other.getUvModality();
        if (this$uvModality == null ? other$uvModality != null : !((Object)this$uvModality).equals(other$uvModality)) {
            return false;
        }
        Optional<Map<CtapCertificationId, Integer>> this$certifications = this.getCertifications();
        Optional<Map<CtapCertificationId, Integer>> other$certifications = other.getCertifications();
        if (this$certifications == null ? other$certifications != null : !((Object)this$certifications).equals(other$certifications)) {
            return false;
        }
        Optional<Set<Integer>> this$vendorPrototypeConfigCommands = this.getVendorPrototypeConfigCommands();
        Optional<Set<Integer>> other$vendorPrototypeConfigCommands = other.getVendorPrototypeConfigCommands();
        return !(this$vendorPrototypeConfigCommands == null ? other$vendorPrototypeConfigCommands != null : !((Object)this$vendorPrototypeConfigCommands).equals(other$vendorPrototypeConfigCommands));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<Integer> $maxMsgSize = this.getMaxMsgSize();
        result = result * 59 + ($maxMsgSize == null ? 43 : ((Object)$maxMsgSize).hashCode());
        Optional<Integer> $maxCredentialCountInList = this.getMaxCredentialCountInList();
        result = result * 59 + ($maxCredentialCountInList == null ? 43 : ((Object)$maxCredentialCountInList).hashCode());
        Optional<Integer> $maxCredentialIdLength = this.getMaxCredentialIdLength();
        result = result * 59 + ($maxCredentialIdLength == null ? 43 : ((Object)$maxCredentialIdLength).hashCode());
        Optional<Integer> $maxSerializedLargeBlobArray = this.getMaxSerializedLargeBlobArray();
        result = result * 59 + ($maxSerializedLargeBlobArray == null ? 43 : ((Object)$maxSerializedLargeBlobArray).hashCode());
        Optional<Boolean> $forcePINChange = this.getForcePINChange();
        result = result * 59 + ($forcePINChange == null ? 43 : ((Object)$forcePINChange).hashCode());
        Optional<Integer> $minPINLength = this.getMinPINLength();
        result = result * 59 + ($minPINLength == null ? 43 : ((Object)$minPINLength).hashCode());
        Optional<Integer> $firmwareVersion = this.getFirmwareVersion();
        result = result * 59 + ($firmwareVersion == null ? 43 : ((Object)$firmwareVersion).hashCode());
        Optional<Integer> $maxCredBlobLength = this.getMaxCredBlobLength();
        result = result * 59 + ($maxCredBlobLength == null ? 43 : ((Object)$maxCredBlobLength).hashCode());
        Optional<Integer> $maxRPIDsForSetMinPINLength = this.getMaxRPIDsForSetMinPINLength();
        result = result * 59 + ($maxRPIDsForSetMinPINLength == null ? 43 : ((Object)$maxRPIDsForSetMinPINLength).hashCode());
        Optional<Integer> $preferredPlatformUvAttempts = this.getPreferredPlatformUvAttempts();
        result = result * 59 + ($preferredPlatformUvAttempts == null ? 43 : ((Object)$preferredPlatformUvAttempts).hashCode());
        Optional<Integer> $remainingDiscoverableCredentials = this.getRemainingDiscoverableCredentials();
        result = result * 59 + ($remainingDiscoverableCredentials == null ? 43 : ((Object)$remainingDiscoverableCredentials).hashCode());
        Set<CtapVersion> $versions = this.getVersions();
        result = result * 59 + ($versions == null ? 43 : ((Object)$versions).hashCode());
        Optional<Set<String>> $extensions = this.getExtensions();
        result = result * 59 + ($extensions == null ? 43 : ((Object)$extensions).hashCode());
        Optional<AAGUID> $aaguid = this.getAaguid();
        result = result * 59 + ($aaguid == null ? 43 : ((Object)$aaguid).hashCode());
        Optional<SupportedCtapOptions> $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        Optional<Set<CtapPinUvAuthProtocolVersion>> $pinUvAuthProtocols = this.getPinUvAuthProtocols();
        result = result * 59 + ($pinUvAuthProtocols == null ? 43 : ((Object)$pinUvAuthProtocols).hashCode());
        Optional<Set<AuthenticatorTransport>> $transports = this.getTransports();
        result = result * 59 + ($transports == null ? 43 : ((Object)$transports).hashCode());
        Optional<List<PublicKeyCredentialParameters>> $algorithms = this.getAlgorithms();
        result = result * 59 + ($algorithms == null ? 43 : ((Object)$algorithms).hashCode());
        Optional<Set<UserVerificationMethod>> $uvModality = this.getUvModality();
        result = result * 59 + ($uvModality == null ? 43 : ((Object)$uvModality).hashCode());
        Optional<Map<CtapCertificationId, Integer>> $certifications = this.getCertifications();
        result = result * 59 + ($certifications == null ? 43 : ((Object)$certifications).hashCode());
        Optional<Set<Integer>> $vendorPrototypeConfigCommands = this.getVendorPrototypeConfigCommands();
        result = result * 59 + ($vendorPrototypeConfigCommands == null ? 43 : ((Object)$vendorPrototypeConfigCommands).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AuthenticatorGetInfo(versions=" + this.getVersions() + ", extensions=" + this.getExtensions() + ", aaguid=" + this.getAaguid() + ", options=" + this.getOptions() + ", maxMsgSize=" + this.getMaxMsgSize() + ", pinUvAuthProtocols=" + this.getPinUvAuthProtocols() + ", maxCredentialCountInList=" + this.getMaxCredentialCountInList() + ", maxCredentialIdLength=" + this.getMaxCredentialIdLength() + ", transports=" + this.getTransports() + ", algorithms=" + this.getAlgorithms() + ", maxSerializedLargeBlobArray=" + this.getMaxSerializedLargeBlobArray() + ", forcePINChange=" + this.getForcePINChange() + ", minPINLength=" + this.getMinPINLength() + ", firmwareVersion=" + this.getFirmwareVersion() + ", maxCredBlobLength=" + this.getMaxCredBlobLength() + ", maxRPIDsForSetMinPINLength=" + this.getMaxRPIDsForSetMinPINLength() + ", preferredPlatformUvAttempts=" + this.getPreferredPlatformUvAttempts() + ", uvModality=" + this.getUvModality() + ", certifications=" + this.getCertifications() + ", remainingDiscoverableCredentials=" + this.getRemainingDiscoverableCredentials() + ", vendorPrototypeConfigCommands=" + this.getVendorPrototypeConfigCommands() + ")";
    }

    @JsonIgnoreProperties(value={"maxAuthenticatorConfigLength", "defaultCredProtect"})
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class AuthenticatorGetInfoBuilder {
        @Generated
        private Set<CtapVersion> versions;
        @Generated
        private Set<String> extensions;
        @Generated
        private AAGUID aaguid;
        @Generated
        private SupportedCtapOptions options;
        @Generated
        private Integer maxMsgSize;
        @Generated
        private Set<CtapPinUvAuthProtocolVersion> pinUvAuthProtocols;
        @Generated
        private Integer maxCredentialCountInList;
        @Generated
        private Integer maxCredentialIdLength;
        @Generated
        private Set<AuthenticatorTransport> transports;
        @Generated
        private List<PublicKeyCredentialParameters> algorithms;
        @Generated
        private Integer maxSerializedLargeBlobArray;
        @Generated
        private Boolean forcePINChange;
        @Generated
        private Integer minPINLength;
        @Generated
        private Integer firmwareVersion;
        @Generated
        private Integer maxCredBlobLength;
        @Generated
        private Integer maxRPIDsForSetMinPINLength;
        @Generated
        private Integer preferredPlatformUvAttempts;
        @Generated
        private Set<UserVerificationMethod> uvModality;
        @Generated
        private Map<CtapCertificationId, Integer> certifications;
        @Generated
        private Integer remainingDiscoverableCredentials;
        @Generated
        private Set<Integer> vendorPrototypeConfigCommands;

        @Generated
        AuthenticatorGetInfoBuilder() {
        }

        @Generated
        public AuthenticatorGetInfoBuilder versions(@NonNull Set<CtapVersion> versions) {
            if (versions == null) {
                throw new NullPointerException("versions is marked non-null but is null");
            }
            this.versions = versions;
            return this;
        }

        @Generated
        public AuthenticatorGetInfoBuilder extensions(Set<String> extensions) {
            this.extensions = extensions;
            return this;
        }

        @Generated
        public AuthenticatorGetInfoBuilder aaguid(AAGUID aaguid) {
            this.aaguid = aaguid;
            return this;
        }

        @Generated
        public AuthenticatorGetInfoBuilder options(SupportedCtapOptions options) {
            this.options = options;
            return this;
        }

        @Generated
        public AuthenticatorGetInfoBuilder maxMsgSize(Integer maxMsgSize) {
            this.maxMsgSize = maxMsgSize;
            return this;
        }

        @Generated
        public AuthenticatorGetInfoBuilder pinUvAuthProtocols(Set<CtapPinUvAuthProtocolVersion> pinUvAuthProtocols) {
            this.pinUvAuthProtocols = pinUvAuthProtocols;
            return this;
        }

        @Generated
        public AuthenticatorGetInfoBuilder maxCredentialCountInList(Integer maxCredentialCountInList) {
            this.maxCredentialCountInList = maxCredentialCountInList;
            return this;
        }

        @Generated
        public AuthenticatorGetInfoBuilder maxCredentialIdLength(Integer maxCredentialIdLength) {
            this.maxCredentialIdLength = maxCredentialIdLength;
            return this;
        }

        @Generated
        public AuthenticatorGetInfoBuilder transports(Set<AuthenticatorTransport> transports) {
            this.transports = transports;
            return this;
        }

        @JsonDeserialize(using=ListPublicKeyCredentialParametersIgnoringUnknownValuesDeserializer.class)
        @Generated
        public AuthenticatorGetInfoBuilder algorithms(List<PublicKeyCredentialParameters> algorithms) {
            this.algorithms = algorithms;
            return this;
        }

        @Generated
        public AuthenticatorGetInfoBuilder maxSerializedLargeBlobArray(Integer maxSerializedLargeBlobArray) {
            this.maxSerializedLargeBlobArray = maxSerializedLargeBlobArray;
            return this;
        }

        @Generated
        public AuthenticatorGetInfoBuilder forcePINChange(Boolean forcePINChange) {
            this.forcePINChange = forcePINChange;
            return this;
        }

        @Generated
        public AuthenticatorGetInfoBuilder minPINLength(Integer minPINLength) {
            this.minPINLength = minPINLength;
            return this;
        }

        @Generated
        public AuthenticatorGetInfoBuilder firmwareVersion(Integer firmwareVersion) {
            this.firmwareVersion = firmwareVersion;
            return this;
        }

        @Generated
        public AuthenticatorGetInfoBuilder maxCredBlobLength(Integer maxCredBlobLength) {
            this.maxCredBlobLength = maxCredBlobLength;
            return this;
        }

        @Generated
        public AuthenticatorGetInfoBuilder maxRPIDsForSetMinPINLength(Integer maxRPIDsForSetMinPINLength) {
            this.maxRPIDsForSetMinPINLength = maxRPIDsForSetMinPINLength;
            return this;
        }

        @Generated
        public AuthenticatorGetInfoBuilder preferredPlatformUvAttempts(Integer preferredPlatformUvAttempts) {
            this.preferredPlatformUvAttempts = preferredPlatformUvAttempts;
            return this;
        }

        @JsonDeserialize(using=SetFromIntJsonDeserializer.class)
        @Generated
        public AuthenticatorGetInfoBuilder uvModality(Set<UserVerificationMethod> uvModality) {
            this.uvModality = uvModality;
            return this;
        }

        @Generated
        public AuthenticatorGetInfoBuilder certifications(Map<CtapCertificationId, Integer> certifications) {
            this.certifications = certifications;
            return this;
        }

        @Generated
        public AuthenticatorGetInfoBuilder remainingDiscoverableCredentials(Integer remainingDiscoverableCredentials) {
            this.remainingDiscoverableCredentials = remainingDiscoverableCredentials;
            return this;
        }

        @Generated
        public AuthenticatorGetInfoBuilder vendorPrototypeConfigCommands(Set<Integer> vendorPrototypeConfigCommands) {
            this.vendorPrototypeConfigCommands = vendorPrototypeConfigCommands;
            return this;
        }

        @Generated
        public AuthenticatorGetInfo build() {
            return new AuthenticatorGetInfo(this.versions, this.extensions, this.aaguid, this.options, this.maxMsgSize, this.pinUvAuthProtocols, this.maxCredentialCountInList, this.maxCredentialIdLength, this.transports, this.algorithms, this.maxSerializedLargeBlobArray, this.forcePINChange, this.minPINLength, this.firmwareVersion, this.maxCredBlobLength, this.maxRPIDsForSetMinPINLength, this.preferredPlatformUvAttempts, this.uvModality, this.certifications, this.remainingDiscoverableCredentials, this.vendorPrototypeConfigCommands);
        }

        @Generated
        public String toString() {
            return "AuthenticatorGetInfo.AuthenticatorGetInfoBuilder(versions=" + this.versions + ", extensions=" + this.extensions + ", aaguid=" + this.aaguid + ", options=" + this.options + ", maxMsgSize=" + this.maxMsgSize + ", pinUvAuthProtocols=" + this.pinUvAuthProtocols + ", maxCredentialCountInList=" + this.maxCredentialCountInList + ", maxCredentialIdLength=" + this.maxCredentialIdLength + ", transports=" + this.transports + ", algorithms=" + this.algorithms + ", maxSerializedLargeBlobArray=" + this.maxSerializedLargeBlobArray + ", forcePINChange=" + this.forcePINChange + ", minPINLength=" + this.minPINLength + ", firmwareVersion=" + this.firmwareVersion + ", maxCredBlobLength=" + this.maxCredBlobLength + ", maxRPIDsForSetMinPINLength=" + this.maxRPIDsForSetMinPINLength + ", preferredPlatformUvAttempts=" + this.preferredPlatformUvAttempts + ", uvModality=" + this.uvModality + ", certifications=" + this.certifications + ", remainingDiscoverableCredentials=" + this.remainingDiscoverableCredentials + ", vendorPrototypeConfigCommands=" + this.vendorPrototypeConfigCommands + ")";
        }
    }

    private static class ListPublicKeyCredentialParametersIgnoringUnknownValuesDeserializer
    extends JsonDeserializer<List<PublicKeyCredentialParameters>> {
        private ListPublicKeyCredentialParametersIgnoringUnknownValuesDeserializer() {
        }

        public List<PublicKeyCredentialParameters> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            PublicKeyCredentialParametersIgnoringUnknownValues[] pkcpiuvs = (PublicKeyCredentialParametersIgnoringUnknownValues[])p.readValueAs(PublicKeyCredentialParametersIgnoringUnknownValues[].class);
            return Arrays.stream(pkcpiuvs).flatMap(pkcpiuv -> {
                if (pkcpiuv != null && ((PublicKeyCredentialParametersIgnoringUnknownValues)pkcpiuv).value != null) {
                    return Stream.of(((PublicKeyCredentialParametersIgnoringUnknownValues)pkcpiuv).value);
                }
                return Stream.empty();
            }).collect(Collectors.toList());
        }
    }

    @JsonDeserialize(using=Deserializer.class)
    private static final class PublicKeyCredentialParametersIgnoringUnknownValues {
        private final PublicKeyCredentialParameters value;

        @Generated
        public PublicKeyCredentialParametersIgnoringUnknownValues(PublicKeyCredentialParameters value) {
            this.value = value;
        }

        @Generated
        public PublicKeyCredentialParameters getValue() {
            return this.value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PublicKeyCredentialParametersIgnoringUnknownValues)) {
                return false;
            }
            PublicKeyCredentialParametersIgnoringUnknownValues other = (PublicKeyCredentialParametersIgnoringUnknownValues)o;
            PublicKeyCredentialParameters this$value = this.getValue();
            PublicKeyCredentialParameters other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PublicKeyCredentialParameters $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AuthenticatorGetInfo.PublicKeyCredentialParametersIgnoringUnknownValues(value=" + this.getValue() + ")";
        }

        private static class Deserializer
        extends JsonDeserializer<PublicKeyCredentialParametersIgnoringUnknownValues> {
            private Deserializer() {
            }

            public PublicKeyCredentialParametersIgnoringUnknownValues deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
                try {
                    return new PublicKeyCredentialParametersIgnoringUnknownValues((PublicKeyCredentialParameters)p.readValueAs(PublicKeyCredentialParameters.class));
                }
                catch (IOException e) {
                    return null;
                }
            }
        }
    }

    private static class IntFromSetJsonSerializer
    extends JsonSerializer<Set<UserVerificationMethod>> {
        private IntFromSetJsonSerializer() {
        }

        public void serialize(Set<UserVerificationMethod> value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeNumber(value.stream().reduce(0, (acc, next) -> acc | next.getValue(), (a, b) -> a | b).intValue());
        }
    }

    private static class SetFromIntJsonDeserializer
    extends JsonDeserializer<Set<UserVerificationMethod>> {
        private SetFromIntJsonDeserializer() {
        }

        public Set<UserVerificationMethod> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            int bitset = p.getNumberValue().intValue();
            return Arrays.stream(UserVerificationMethod.values()).filter(uvm -> (uvm.getValue() & bitset) != 0).collect(Collectors.toSet());
        }
    }
}

