/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.endpoints;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.support.oauth.web.endpoints.BaseOAuth20Controller;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.OAuth20AuthorizationRequest;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationResponseBuilder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.util.JsonUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.jooq.lambda.Unchecked;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.OrderComparator;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.servlet.ModelAndView;

public class OAuth20AuthorizeEndpointController<T extends OAuth20ConfigurationContext>
extends BaseOAuth20Controller<T> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20AuthorizeEndpointController.class);

    public OAuth20AuthorizeEndpointController(T oAuthConfigurationContext) {
        super(oAuthConfigurationContext);
    }

    private static Optional<OAuth20AuthorizationRequest.OAuth20AuthorizationRequestBuilder> toAuthorizationRequest(OAuthRegisteredService registeredService, JEEContext context, Service service, Authentication authentication, OAuth20AuthorizationResponseBuilder builder) {
        return builder.toAuthorizationRequest((WebContext)context, authentication, service, registeredService);
    }

    @GetMapping(path={"/oauth2.0/authorize"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        ModelAndView mv;
        ModelAndView mv2;
        OAuth20RequestParameterResolver requestParameterResolver = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getRequestParameterResolver();
        JEEContext webContext = new JEEContext(request, response);
        Set prompts = requestParameterResolver.resolveSupportedPromptValues((WebContext)webContext);
        Set requestedPrompt = requestParameterResolver.resolveRequestedPromptValues((WebContext)webContext);
        if (!requestedPrompt.isEmpty() && !requestedPrompt.equals(prompts)) {
            return OAuth20Utils.writeError(response, "invalid_request", "Unsupported prompt parameter value");
        }
        this.ensureSessionReplicationIsAutoconfiguredIfNeedBe(request);
        JEEContext context = new JEEContext(request, response);
        ProfileManager manager = new ProfileManager((WebContext)context, ((OAuth20ConfigurationContext)this.getConfigurationContext()).getSessionStore());
        if (context.getRequestAttribute("error").isPresent() && !(mv2 = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getOauthInvalidAuthorizationResponseBuilder().build(context)).isEmpty() && mv2.hasView()) {
            return mv2;
        }
        String clientId = requestParameterResolver.resolveRequestParameter((WebContext)context, "client_id").map(String::valueOf).orElse("");
        OAuthRegisteredService registeredService = this.getRegisteredServiceByClientId(clientId);
        WebApplicationService clientService = (WebApplicationService)((OAuth20ConfigurationContext)this.getConfigurationContext()).getWebApplicationServiceServiceFactory().createService(clientId);
        RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)clientService, (RegisteredService)registeredService);
        if (LoggingUtils.isProtocolMessageLoggerEnabled()) {
            String redirectUri = requestParameterResolver.resolveRequestParameter((WebContext)context, "redirect_uri").orElse("");
            String responseType = requestParameterResolver.resolveRequestParameter((WebContext)context, "response_type").orElse("");
            String scopes = requestParameterResolver.resolveRequestParameter((WebContext)context, "scope").orElse("");
            String state = requestParameterResolver.resolveRequestParameter((WebContext)context, "state").orElse("");
            LoggingUtils.protocolMessage((String)"OAuth/OpenID Connect Authorization Request", Map.of("Registered Service", registeredService.getName(), "Client ID", clientId, "State", state, "Redirect URI", redirectUri, "Response Type", responseType, "Scopes", scopes));
        }
        if (this.isRequestAuthenticated(manager, (WebContext)context, registeredService) && !(mv = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getConsentApprovalViewResolver().resolve((WebContext)context, registeredService)).isEmpty() && mv.hasView()) {
            LOGGER.debug("Redirecting to consent-approval view with model [{}]", (Object)mv.getModel());
            return mv;
        }
        return this.redirectToCallbackRedirectUrl(manager, registeredService, context);
    }

    @PostMapping(path={"/oauth2.0/authorize"})
    public ModelAndView handleRequestPost(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        return this.handleRequest(request, response);
    }

    protected ModelAndView redirectToCallbackRedirectUrl(ProfileManager manager, OAuthRegisteredService registeredService, JEEContext context) throws Throwable {
        UserProfile profile = this.verifyAndReturnAuthenticatedProfile(manager, context);
        Service service = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getAuthenticationBuilder().buildService(registeredService, (WebContext)context, false);
        LOGGER.trace("Created service [{}] based on registered service [{}]", (Object)service, (Object)registeredService);
        Authentication authentication = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getAuthenticationBuilder().build(profile, registeredService, (WebContext)context, service);
        LOGGER.trace("Created OAuth authentication [{}] for service [{}]", (Object)authentication, (Object)service);
        try {
            AuditableContext audit = AuditableContext.builder().service(service).registeredService((RegisteredService)registeredService).principal(authentication.getPrincipal()).build();
            AuditableExecutionResult accessResult = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getRegisteredServiceAccessStrategyEnforcer().execute(audit);
            accessResult.throwExceptionIfNeeded();
            ModelAndView modelAndView = this.buildAuthorizationForRequest(registeredService, context, service, authentication);
            return Optional.ofNullable(modelAndView).filter(ModelAndView::hasView).orElseGet(() -> {
                LOGGER.trace("No explicit view was defined as part of the authorization response");
                return null;
            });
        }
        catch (Throwable e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return OAuth20Utils.produceUnauthorizedErrorView(HttpStatus.FORBIDDEN);
        }
    }

    private UserProfile verifyAndReturnAuthenticatedProfile(ProfileManager manager, JEEContext context) {
        CasConfigurationProperties casProperties = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getCasProperties();
        return (UserProfile)manager.getProfile().orElseThrow(() -> new IllegalArgumentException("CAS is unable to locate authentication profile for this request: %s. The authentication request is expected\nto have been verified with an authentication attempt, and yet there is no record of an authentication event.\nThis issue is typically the result of CAS misconfiguration. Please examine your CAS setup and review your\nOIDC configuration. Your OIDC issuer is defined as %s, and your CAS server name is %s.\n".stripIndent().formatted(context.getFullRequestURL(), casProperties.getAuthn().getOidc().getCore().getIssuer(), casProperties.getServer().getPrefix())));
    }

    protected ModelAndView buildAuthorizationForRequest(OAuthRegisteredService registeredService, JEEContext context, Service service, Authentication authentication) {
        List registeredBuilders = (List)((OAuth20ConfigurationContext)this.getConfigurationContext()).getOauthAuthorizationResponseBuilders().getObject();
        OAuth20AuthorizationRequest authzRequest = ((OAuth20AuthorizationRequest.OAuth20AuthorizationRequestBuilder)registeredBuilders.stream().filter(BeanSupplier::isNotProxy).sorted((Comparator<OAuth20AuthorizationResponseBuilder>)OrderComparator.INSTANCE).map(builder -> OAuth20AuthorizeEndpointController.toAuthorizationRequest(registeredService, context, service, authentication, builder)).filter(Objects::nonNull).filter(Optional::isPresent).findFirst().orElseThrow(() -> new IllegalArgumentException("Unable to build authorization request")).orElseThrow()).build();
        AccessTokenRequestContext payload = Optional.ofNullable(authzRequest.getAccessTokenRequest()).orElseGet(Unchecked.supplier(() -> this.prepareAccessTokenRequestContext(authzRequest, registeredService, context, service, authentication)));
        ModelAndView result = registeredBuilders.stream().filter(BeanSupplier::isNotProxy).sorted((Comparator<OAuth20AuthorizationResponseBuilder>)OrderComparator.INSTANCE).filter(builder -> builder.supports(authzRequest)).findFirst().map(Unchecked.function(builder -> {
            if (authzRequest.isSingleSignOnSessionRequired() && payload.getTicketGrantingTicket() == null && !OAuth20Utils.isStatelessAuthentication(payload.getUserProfile()).booleanValue()) {
                String message = String.format("Missing ticket-granting-ticket for client id [%s] and service [%s]", authzRequest.getClientId(), registeredService.getName());
                LOGGER.error(message);
                return OAuth20Utils.produceErrorView((Exception)new PreventedException(message));
            }
            return builder.build(payload);
        })).orElseGet(() -> OAuth20Utils.produceErrorView((Exception)new PreventedException("Could not build the callback response")));
        if (LoggingUtils.isProtocolMessageLoggerEnabled()) {
            LoggingUtils.protocolMessage((String)"OAuth/OpenID Connect Authorization Response", Map.of("Service", service.getId(), "Client ID", payload.getClientId(), "Response Mode", payload.getResponseMode(), "Response Type", payload.getResponseType(), "Redirect URI", payload.getRedirectUri()), (Object)(result.getModel().isEmpty() ? "" : JsonUtils.render((Object)result.getModel())));
        }
        return result;
    }

    protected AccessTokenRequestContext prepareAccessTokenRequestContext(OAuth20AuthorizationRequest authzRequest, OAuthRegisteredService registeredService, JEEContext context, Service service, Authentication authentication) throws Exception {
        AccessTokenRequestContext.AccessTokenRequestContextBuilder payloadBuilder = AccessTokenRequestContext.builder();
        if (authzRequest.isSingleSignOnSessionRequired()) {
            TicketGrantingTicket tgt = ((OAuth20ConfigurationContext)this.getConfigurationContext()).fetchTicketGrantingTicketFrom(context);
            payloadBuilder = payloadBuilder.ticketGrantingTicket((Ticket)tgt);
        }
        OAuth20RequestParameterResolver requestParameterResolver = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getRequestParameterResolver();
        String redirectUri = requestParameterResolver.resolveRequestParameter((WebContext)context, "redirect_uri").map(String::valueOf).orElse("");
        String grantType = context.getRequestParameter("grant_type").map(String::valueOf).orElseGet(() -> ((OAuth20GrantTypes)OAuth20GrantTypes.AUTHORIZATION_CODE).getType()).toUpperCase(Locale.ENGLISH);
        Set scopes = requestParameterResolver.resolveRequestScopes((WebContext)context);
        String codeChallenge = context.getRequestParameter("code_challenge").map(String::valueOf).orElse("");
        List challengeMethodsSupported = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getCasProperties().getAuthn().getOidc().getDiscovery().getCodeChallengeMethodsSupported();
        String codeChallengeMethod = context.getRequestParameter("code_challenge_method").map(String::valueOf).filter(challengeMethodsSupported::contains).orElse("").toUpperCase(Locale.ENGLISH);
        UserProfile userProfile = OAuth20Utils.getAuthenticatedUserProfile((WebContext)context, ((OAuth20ConfigurationContext)this.getConfigurationContext()).getSessionStore());
        Map claims = requestParameterResolver.resolveRequestClaims((WebContext)context);
        AccessTokenRequestContext holder = payloadBuilder.service(service).authentication(authentication).registeredService(registeredService).grantType(requestParameterResolver.resolveGrantType((WebContext)context)).responseType(requestParameterResolver.resolveResponseType((WebContext)context)).codeChallenge(codeChallenge).codeChallengeMethod(codeChallengeMethod).scopes(scopes).clientId(authzRequest.getClientId()).redirectUri(redirectUri).userProfile(userProfile).claims(claims).responseMode(requestParameterResolver.resolveResponseModeType((WebContext)context)).build();
        context.getRequestParameters().keySet().forEach(key -> context.getRequestParameter(key).ifPresent(value -> holder.getParameters().put(key, value)));
        LOGGER.debug("Building authorization response for grant type [{}] with scopes [{}] for client id [{}]", new Object[]{grantType, scopes, authzRequest.getClientId()});
        return holder;
    }
}

