/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.matching.matcher.csrf;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.Cookie;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.matching.matcher.Matcher;
import org.pac4j.core.matching.matcher.csrf.CsrfTokenGenerator;
import org.pac4j.core.util.CommonHelper;

public class CsrfTokenGeneratorMatcher
implements Matcher {
    private CsrfTokenGenerator csrfTokenGenerator;
    private String domain;
    private String path = "/";
    private Boolean httpOnly = true;
    private Boolean secure = true;
    private Integer maxAge;
    private String sameSitePolicy;
    private boolean addTokenAsAttribute = true;
    private boolean addTokenAsHeader = false;
    private boolean addTokenAsCookie = true;

    public CsrfTokenGeneratorMatcher(CsrfTokenGenerator csrfTokenGenerator) {
        this.csrfTokenGenerator = csrfTokenGenerator;
    }

    @Override
    public boolean matches(CallContext ctx) {
        WebContext webContext = ctx.webContext();
        CommonHelper.assertNotNull("csrfTokenGenerator", this.csrfTokenGenerator);
        if (this.addTokenAsAttribute || this.addTokenAsHeader || this.addTokenAsCookie) {
            String token = this.csrfTokenGenerator.get(webContext, ctx.sessionStore());
            if (this.addTokenAsAttribute) {
                webContext.setRequestAttribute("pac4jCsrfToken", token);
            }
            if (this.addTokenAsHeader) {
                webContext.setResponseHeader("pac4jCsrfToken", token);
            }
            if (this.addTokenAsCookie) {
                Cookie cookie = new Cookie("pac4jCsrfToken", token);
                if (StringUtils.isNotBlank((CharSequence)this.domain)) {
                    cookie.setDomain(this.domain);
                } else {
                    cookie.setDomain(webContext.getServerName());
                }
                if (StringUtils.isNotBlank((CharSequence)this.path)) {
                    cookie.setPath(this.path);
                }
                if (this.httpOnly != null) {
                    cookie.setHttpOnly(this.httpOnly);
                }
                if (this.secure != null) {
                    cookie.setSecure(this.secure);
                }
                if (this.maxAge != null) {
                    cookie.setMaxAge(this.maxAge);
                }
                if (StringUtils.isNotBlank((CharSequence)this.sameSitePolicy)) {
                    cookie.setSameSitePolicy(this.sameSitePolicy);
                }
                webContext.addResponseCookie(cookie);
            }
        }
        return true;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CsrfTokenGenerator getCsrfTokenGenerator() {
        return this.csrfTokenGenerator;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDomain() {
        return this.domain;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPath() {
        return this.path;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Boolean getHttpOnly() {
        return this.httpOnly;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Boolean getSecure() {
        return this.secure;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Integer getMaxAge() {
        return this.maxAge;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getSameSitePolicy() {
        return this.sameSitePolicy;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isAddTokenAsAttribute() {
        return this.addTokenAsAttribute;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isAddTokenAsHeader() {
        return this.addTokenAsHeader;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isAddTokenAsCookie() {
        return this.addTokenAsCookie;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCsrfTokenGenerator(CsrfTokenGenerator csrfTokenGenerator) {
        this.csrfTokenGenerator = csrfTokenGenerator;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setHttpOnly(Boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setSecure(Boolean secure) {
        this.secure = secure;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setSameSitePolicy(String sameSitePolicy) {
        this.sameSitePolicy = sameSitePolicy;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAddTokenAsAttribute(boolean addTokenAsAttribute) {
        this.addTokenAsAttribute = addTokenAsAttribute;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAddTokenAsHeader(boolean addTokenAsHeader) {
        this.addTokenAsHeader = addTokenAsHeader;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAddTokenAsCookie(boolean addTokenAsCookie) {
        this.addTokenAsCookie = addTokenAsCookie;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "CsrfTokenGeneratorMatcher(csrfTokenGenerator=" + this.csrfTokenGenerator + ", domain=" + this.domain + ", path=" + this.path + ", httpOnly=" + this.httpOnly + ", secure=" + this.secure + ", maxAge=" + this.maxAge + ", sameSitePolicy=" + this.sameSitePolicy + ", addTokenAsAttribute=" + this.addTokenAsAttribute + ", addTokenAsHeader=" + this.addTokenAsHeader + ", addTokenAsCookie=" + this.addTokenAsCookie + ")";
    }
}

