/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.Map;
import java.util.Optional;
import javax.security.auth.login.CredentialNotFoundException;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationPostProcessor;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.SurrogateAuthenticationException;
import org.apereo.cas.authentication.SurrogatePrincipal;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.surrogate.SurrogateAuthenticationService;
import org.apereo.cas.authentication.surrogate.SurrogateCredentialTrait;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.events.AbstractCasEvent;
import org.apereo.cas.support.events.authentication.surrogate.CasSurrogateAuthenticationFailureEvent;
import org.apereo.cas.support.events.authentication.surrogate.CasSurrogateAuthenticationSuccessfulEvent;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class SurrogateAuthenticationPostProcessor
implements AuthenticationPostProcessor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SurrogateAuthenticationPostProcessor.class);
    private final SurrogateAuthenticationService surrogateAuthenticationService;
    private final ServicesManager servicesManager;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final AuditableExecution registeredServiceAccessStrategyEnforcer;
    private final AuditableExecution surrogateEligibilityAuditableExecution;

    public void process(AuthenticationBuilder builder, AuthenticationTransaction transaction) throws Throwable {
        Authentication authentication = builder.build();
        Principal principal = authentication.getPrincipal();
        if (!(principal instanceof SurrogatePrincipal)) {
            LOGGER.trace("Provided principal is one intended for surrogate authentication");
            return;
        }
        SurrogatePrincipal primaryPrincipal = (SurrogatePrincipal)principal;
        Optional primaryCredential = transaction.getPrimaryCredential();
        if (primaryCredential.isEmpty()) {
            throw new AuthenticationException("Unable to determine primary credentials");
        }
        String surrogateUsername = ((Credential)primaryCredential.get()).getCredentialMetadata().getTrait(SurrogateCredentialTrait.class).map(SurrogateCredentialTrait::getSurrogateUsername).orElseThrow(() -> new AuthenticationException("Unable to determine surrogate credential"));
        try {
            if (StringUtils.isBlank((CharSequence)surrogateUsername)) {
                LOGGER.error("No surrogate username was specified as part of the credential");
                throw new CredentialNotFoundException("Missing surrogate username in credential");
            }
            LOGGER.debug("Authenticated [{}] will be checked for surrogate eligibility next for [{}]...", (Object)primaryPrincipal, (Object)surrogateUsername);
            if (transaction.getService() != null) {
                RegisteredService svc = this.servicesManager.findServiceBy(transaction.getService());
                AuditableContext serviceAccessAudit = AuditableContext.builder().service(transaction.getService()).authentication(authentication).registeredService(svc).build();
                AuditableExecutionResult accessResult = this.registeredServiceAccessStrategyEnforcer.execute(serviceAccessAudit);
                accessResult.throwExceptionIfNeeded();
            }
            if (this.surrogateAuthenticationService.canImpersonate(surrogateUsername, primaryPrincipal.getPrimary(), Optional.ofNullable(transaction.getService()))) {
                LOGGER.debug("Principal [{}] is authorized to authenticate as [{}]", (Object)primaryPrincipal, (Object)surrogateUsername);
                this.publishSuccessEvent(primaryPrincipal, surrogateUsername);
                AuditableContext surrogateEligibleAudit = AuditableContext.builder().service(transaction.getService()).authentication(authentication).properties(CollectionUtils.wrap((String)"targetUserId", (Object)surrogateUsername, (String)"eligible", (Object)Boolean.TRUE)).build();
                this.surrogateEligibilityAuditableExecution.execute(surrogateEligibleAudit);
                return;
            }
            LOGGER.error("Principal [{}] is unable/unauthorized to authenticate as [{}]", (Object)primaryPrincipal, (Object)surrogateUsername);
            throw new FailedLoginException();
        }
        catch (Exception e) {
            this.publishFailureEvent(primaryPrincipal, surrogateUsername);
            Map map = CollectionUtils.wrap((String)this.getClass().getSimpleName(), (Object)((Object)new SurrogateAuthenticationException("Principal " + String.valueOf(primaryPrincipal) + " is unauthorized to authenticate as " + surrogateUsername)));
            AuditableContext surrogateIneligibleAudit = AuditableContext.builder().service(transaction.getService()).authentication(authentication).build();
            this.surrogateEligibilityAuditableExecution.execute(surrogateIneligibleAudit);
            throw new AuthenticationException(map);
        }
    }

    public boolean supports(Credential credential) {
        return credential.getCredentialMetadata().getTrait(SurrogateCredentialTrait.class).stream().anyMatch(trait -> StringUtils.isNotBlank((CharSequence)trait.getSurrogateUsername()));
    }

    private void publishFailureEvent(Principal principal, String surrogate) {
        ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
        CasSurrogateAuthenticationFailureEvent event = new CasSurrogateAuthenticationFailureEvent((Object)this, principal, surrogate, clientInfo);
        this.publishEvent((AbstractCasEvent)event);
    }

    private void publishSuccessEvent(Principal principal, String surrogate) {
        ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
        CasSurrogateAuthenticationSuccessfulEvent event = new CasSurrogateAuthenticationSuccessfulEvent((Object)this, principal, surrogate, clientInfo);
        this.publishEvent((AbstractCasEvent)event);
    }

    private void publishEvent(AbstractCasEvent event) {
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)event);
        }
    }

    @Generated
    public SurrogateAuthenticationPostProcessor(SurrogateAuthenticationService surrogateAuthenticationService, ServicesManager servicesManager, ApplicationEventPublisher applicationEventPublisher, AuditableExecution registeredServiceAccessStrategyEnforcer, AuditableExecution surrogateEligibilityAuditableExecution) {
        this.surrogateAuthenticationService = surrogateAuthenticationService;
        this.servicesManager = servicesManager;
        this.applicationEventPublisher = applicationEventPublisher;
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
        this.surrogateEligibilityAuditableExecution = surrogateEligibilityAuditableExecution;
    }
}

