/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.support.saml.services.BaseSamlRegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceMetadataAdaptor;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.util.RegexUtils;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternMatchingEntityIdAttributeReleasePolicy
extends BaseSamlRegisteredServiceAttributeReleasePolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PatternMatchingEntityIdAttributeReleasePolicy.class);
    private static final long serialVersionUID = 2633701342213724854L;
    private String entityIds = RegexUtils.MATCH_NOTHING_PATTERN.pattern();
    private boolean fullMatch = true;
    private boolean reverseMatch;

    @Override
    protected Map<String, List<Object>> getAttributesForSamlRegisteredService(Map<String, List<Object>> attributes, SamlRegisteredServiceCachingMetadataResolver resolver, SamlRegisteredServiceMetadataAdaptor facade, EntityDescriptor entityDescriptor, RegisteredServiceAttributeReleasePolicyContext context) {
        Pattern pattern = RegexUtils.createPattern((String)this.entityIds);
        String entityID = entityDescriptor.getEntityID();
        Matcher matcher = pattern.matcher(entityID);
        boolean matched = this.fullMatch ? matcher.matches() : matcher.find();
        LOGGER.debug("Pattern [{}] matched against [{}]? [{}]", new Object[]{pattern.pattern(), entityID, BooleanUtils.toStringYesNo((boolean)matched)});
        if (this.reverseMatch) {
            matched = !matched;
            LOGGER.debug("Reversed match to be [{}]", (Object)BooleanUtils.toStringYesNo((boolean)matched));
        }
        return matched ? this.authorizeReleaseOfAllowedAttributes(context, attributes) : new HashMap();
    }

    @Generated
    public String getEntityIds() {
        return this.entityIds;
    }

    @Generated
    public boolean isFullMatch() {
        return this.fullMatch;
    }

    @Generated
    public boolean isReverseMatch() {
        return this.reverseMatch;
    }

    @Generated
    public void setEntityIds(String entityIds) {
        this.entityIds = entityIds;
    }

    @Generated
    public void setFullMatch(boolean fullMatch) {
        this.fullMatch = fullMatch;
    }

    @Generated
    public void setReverseMatch(boolean reverseMatch) {
        this.reverseMatch = reverseMatch;
    }
}

