/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.task.api.Task;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public abstract class NeedsActiveTaskCmd<T>
implements Command<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;

    public NeedsActiveTaskCmd(String taskId) {
        this.taskId = taskId;
    }

    public T execute(CommandContext commandContext) {
        if (this.taskId == null) {
            throw new FlowableIllegalArgumentException("taskId is null");
        }
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        TaskEntity task = processEngineConfiguration.getTaskServiceConfiguration().getTaskService().getTask(this.taskId);
        if (task == null) {
            throw new FlowableObjectNotFoundException("Cannot find task with id " + this.taskId, Task.class);
        }
        if (task.isDeleted()) {
            throw new FlowableException(String.valueOf(task) + " is already deleted");
        }
        if (task.isSuspended()) {
            throw new FlowableException(this.getSuspendedTaskExceptionPrefix() + " a suspended " + String.valueOf(task));
        }
        return this.execute(commandContext, task);
    }

    protected abstract T execute(CommandContext var1, TaskEntity var2);

    protected String getSuspendedTaskExceptionPrefix() {
        return "Cannot execute operation for";
    }
}

