/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.support.password;

import lombok.Generated;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.scripting.ExecutableCompiledScript;
import org.apereo.cas.util.scripting.ExecutableCompiledScriptFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.security.crypto.password.AbstractPasswordEncoder;

public class GroovyPasswordEncoder
extends AbstractPasswordEncoder
implements DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyPasswordEncoder.class);
    private final ExecutableCompiledScript watchableScript;
    private final ApplicationContext applicationContext;

    public GroovyPasswordEncoder(Resource groovyScript, ApplicationContext applicationContext) {
        ExecutableCompiledScriptFactory scriptFactory = ExecutableCompiledScriptFactory.getExecutableCompiledScriptFactory();
        this.watchableScript = scriptFactory.fromResource(groovyScript);
        this.applicationContext = applicationContext;
    }

    public boolean matches(CharSequence rawPassword, String encodedPassword) {
        return (Boolean)FunctionUtils.doUnchecked(() -> {
            Object[] args = new Object[]{rawPassword, encodedPassword, LOGGER, this.applicationContext};
            return (Boolean)this.watchableScript.execute("matches", Boolean.class, args);
        });
    }

    protected byte[] encode(CharSequence rawPassword, byte[] salt) {
        return (byte[])FunctionUtils.doUnchecked(() -> {
            Object[] args = new Object[]{rawPassword, salt, LOGGER, this.applicationContext};
            return (byte[])this.watchableScript.execute(args, byte[].class);
        });
    }

    public void destroy() {
        this.watchableScript.close();
    }

    @Generated
    public GroovyPasswordEncoder(ExecutableCompiledScript watchableScript, ApplicationContext applicationContext) {
        this.watchableScript = watchableScript;
        this.applicationContext = applicationContext;
    }
}

