/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.PrincipalElectionStrategy;
import org.apereo.cas.authentication.PrincipalElectionStrategyConflictResolver;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.merger.AttributeMerger;
import org.apereo.cas.authentication.principal.merger.ReplacingAttributeAdder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPrincipalElectionStrategy
implements PrincipalElectionStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPrincipalElectionStrategy.class);
    private static final long serialVersionUID = 6704726217030836315L;
    private final PrincipalFactory principalFactory;
    private final PrincipalElectionStrategyConflictResolver principalElectionConflictResolver;
    private AttributeMerger attributeMerger = new ReplacingAttributeAdder();
    private int order = Integer.MAX_VALUE;

    public DefaultPrincipalElectionStrategy() {
        this(PrincipalFactoryUtils.newPrincipalFactory(), PrincipalElectionStrategyConflictResolver.last());
    }

    public DefaultPrincipalElectionStrategy(PrincipalElectionStrategyConflictResolver principalElectionConflictResolver) {
        this(PrincipalFactoryUtils.newPrincipalFactory(), principalElectionConflictResolver);
    }

    public Principal nominate(Collection<Authentication> authentications, Map<String, List<Object>> principalAttributes) throws Throwable {
        Principal principal = this.getPrincipalFromAuthentication(authentications);
        Map<String, List<Object>> attributes = this.getPrincipalAttributesForPrincipal(authentications, principal, principalAttributes);
        Principal finalPrincipal = this.principalFactory.createPrincipal(principal.getId(), attributes);
        LOGGER.debug("Nominated [{}] as the primary principal", (Object)finalPrincipal);
        return finalPrincipal;
    }

    public Principal nominate(List<Principal> principals, Map<String, List<Object>> attributes) throws Throwable {
        LinkedHashSet principalIds = principals.stream().filter(Objects::nonNull).map(p -> p.getId().trim().toLowerCase(Locale.ENGLISH)).collect(Collectors.toCollection(LinkedHashSet::new));
        int count = principalIds.size();
        if (count > 1) {
            LOGGER.debug("Principal resolvers produced [{}] distinct principals [{}]", (Object)count, (Object)principalIds);
        }
        return this.electPrincipal(principals, attributes);
    }

    protected Principal electPrincipal(List<Principal> principals, Map<String, List<Object>> attributes) throws Throwable {
        Principal principal = this.principalElectionConflictResolver.resolve(principals);
        Principal finalPrincipal = this.principalFactory.createPrincipal(principal.getId(), attributes);
        LOGGER.debug("Final principal constructed by the chain of resolvers is [{}]", (Object)finalPrincipal);
        return finalPrincipal;
    }

    protected Map<String, List<Object>> getPrincipalAttributesForPrincipal(Collection<Authentication> authentications, Principal principal, Map<String, List<Object>> principalAttributes) {
        return principalAttributes;
    }

    protected Principal getPrincipalFromAuthentication(Collection<Authentication> authentications) {
        List principals = authentications.stream().map(Authentication::getPrincipal).collect(Collectors.toList());
        return this.principalElectionConflictResolver.resolve(principals);
    }

    @Generated
    public DefaultPrincipalElectionStrategy(PrincipalFactory principalFactory, PrincipalElectionStrategyConflictResolver principalElectionConflictResolver) {
        this.principalFactory = principalFactory;
        this.principalElectionConflictResolver = principalElectionConflictResolver;
    }

    @Generated
    public void setAttributeMerger(AttributeMerger attributeMerger) {
        this.attributeMerger = attributeMerger;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public PrincipalFactory getPrincipalFactory() {
        return this.principalFactory;
    }

    @Generated
    public PrincipalElectionStrategyConflictResolver getPrincipalElectionConflictResolver() {
        return this.principalElectionConflictResolver;
    }

    @Generated
    public AttributeMerger getAttributeMerger() {
        return this.attributeMerger;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }
}

