/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.badge;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.utilities.BackgroundColorBehavior;
import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.core.util.Components;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;

public class BadgeBehavior
extends Behavior {
    private static final long serialVersionUID = 1L;
    private BackgroundColorBehavior.Color color;
    private boolean isPill;

    public BadgeBehavior() {
        this(BackgroundColorBehavior.Color.Secondary, false);
    }

    public BadgeBehavior(BackgroundColorBehavior.Color color) {
        this(color, false);
    }

    public BadgeBehavior(BackgroundColorBehavior.Color color, boolean isPill) {
        this.color = color;
        this.isPill = isPill;
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        Components.assertTag(component, tag, "span", "a");
        Attributes.addClass(tag, this.className(), this.color.cssClassName());
        if (this.isPill) {
            Attributes.addClass(tag, this.pillClassName());
        }
    }

    public void bind(Component component) {
        super.bind(component);
        BootstrapBaseBehavior.addTo(component);
    }

    public void unbind(Component component) {
        super.unbind(component);
        BootstrapBaseBehavior.removeFrom(component);
    }

    protected String pillClassName() {
        return "rounded-pill";
    }

    protected String className() {
        return "badge";
    }

    public BadgeBehavior pill(boolean isPill) {
        this.isPill = isPill;
        return this;
    }

    public BadgeBehavior color(BackgroundColorBehavior.Color color) {
        this.color = color;
        return this;
    }
}

