/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.BaseBpmnXMLConverter;
import org.flowable.bpmn.converter.child.BaseChildElementParser;
import org.flowable.bpmn.converter.child.InParameterParser;
import org.flowable.bpmn.converter.child.VariableListenerEventDefinitionParser;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.ErrorEventDefinition;
import org.flowable.bpmn.model.Event;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.ExtensionAttribute;
import org.flowable.bpmn.model.ExtensionElement;

public class BoundaryEventXMLConverter
extends BaseBpmnXMLConverter {
    protected Map<String, BaseChildElementParser> childParserMap = new HashMap<String, BaseChildElementParser>();
    protected static final List<ExtensionAttribute> defaultBoundaryEventAttributes = Arrays.asList(new ExtensionAttribute("cancelActivity"), new ExtensionAttribute("attachedToRef"));

    public BoundaryEventXMLConverter() {
        InParameterParser inParameterParser = new InParameterParser();
        this.childParserMap.put(inParameterParser.getElementName(), inParameterParser);
        VariableListenerEventDefinitionParser variableListenerEventDefinitionParser = new VariableListenerEventDefinitionParser();
        this.childParserMap.put(variableListenerEventDefinitionParser.getElementName(), variableListenerEventDefinitionParser);
    }

    @Override
    public Class<? extends BaseElement> getBpmnElementType() {
        return BoundaryEvent.class;
    }

    @Override
    protected String getXMLElementName() {
        return "boundaryEvent";
    }

    @Override
    protected BaseElement convertXMLToElement(XMLStreamReader xtr, BpmnModel model) throws Exception {
        EventDefinition eventDef;
        String cancelActivity;
        BoundaryEvent boundaryEvent = new BoundaryEvent();
        BpmnXMLUtil.addXMLLocation((BaseElement)boundaryEvent, xtr);
        String elementId = xtr.getAttributeValue(null, "id");
        boundaryEvent.setId(elementId);
        if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "cancelActivity")) && "false".equalsIgnoreCase(cancelActivity = xtr.getAttributeValue(null, "cancelActivity"))) {
            boundaryEvent.setCancelActivity(false);
        }
        boundaryEvent.setAttachedToRefId(xtr.getAttributeValue(null, "attachedToRef"));
        BpmnXMLUtil.addCustomAttributes(xtr, (BaseElement)boundaryEvent, defaultElementAttributes, defaultActivityAttributes, defaultBoundaryEventAttributes);
        this.parseChildElements(this.getXMLElementName(), (BaseElement)boundaryEvent, this.childParserMap, model, xtr);
        if (boundaryEvent.getEventDefinitions().size() == 1 && (eventDef = (EventDefinition)boundaryEvent.getEventDefinitions().get(0)) instanceof ErrorEventDefinition) {
            boundaryEvent.setCancelActivity(false);
        }
        return boundaryEvent;
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        String eventTypeValue;
        List eventTypeExtensionElements;
        BoundaryEvent boundaryEvent = (BoundaryEvent)element;
        if (boundaryEvent.getAttachedToRef() != null) {
            this.writeDefaultAttribute("attachedToRef", boundaryEvent.getAttachedToRef().getId(), xtw);
        }
        if (boundaryEvent.getEventDefinitions().size() == 1) {
            EventDefinition eventDef = (EventDefinition)boundaryEvent.getEventDefinitions().get(0);
            if (!(eventDef instanceof ErrorEventDefinition)) {
                this.writeDefaultAttribute("cancelActivity", String.valueOf(boundaryEvent.isCancelActivity()).toLowerCase(), xtw);
            }
        } else if (!boundaryEvent.getExtensionElements().isEmpty() && (eventTypeExtensionElements = (List)boundaryEvent.getExtensionElements().get("eventType")) != null && !eventTypeExtensionElements.isEmpty() && StringUtils.isNotEmpty((CharSequence)(eventTypeValue = ((ExtensionElement)eventTypeExtensionElements.get(0)).getElementText()))) {
            this.writeDefaultAttribute("cancelActivity", String.valueOf(boundaryEvent.isCancelActivity()).toLowerCase(), xtw);
        }
    }

    @Override
    protected boolean writeExtensionChildElements(BaseElement element, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        BoundaryEvent boundaryEvent = (BoundaryEvent)element;
        didWriteExtensionStartElement = BpmnXMLUtil.writeIOParameters("in", boundaryEvent.getInParameters(), didWriteExtensionStartElement, xtw);
        didWriteExtensionStartElement = this.writeVariableListenerDefinition((Event)boundaryEvent, didWriteExtensionStartElement, xtw);
        return didWriteExtensionStartElement;
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        BoundaryEvent boundaryEvent = (BoundaryEvent)element;
        this.writeEventDefinitions((Event)boundaryEvent, boundaryEvent.getEventDefinitions(), model, xtw);
    }
}

