/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.HashMap;
import java.util.List;
import kafka.server.AbstractApiVersionsRequestTest;
import kafka.server.ApiVersionsRequestTest$;
import kafka.test.ClusterConfig;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTemplate;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import org.apache.kafka.common.message.ApiVersionsRequestData;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.reflect.ScalaSignature;

@ExtendWith(value={ClusterTestExtensions.class})
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015u!\u0002\u000b\u0016\u0011\u0003Qb!\u0002\u000f\u0016\u0011\u0003i\u0002\"\u0002\u0013\u0002\t\u0003)\u0003\"\u0002\u0014\u0002\t\u00039\u0003\"B\u001e\u0002\t\u0003a\u0004\"\u0002$\u0002\t\u0003a\u0004\"B$\u0002\t\u0003a\u0004\"\u0002%\u0002\t\u0003ad\u0001\u0002\u000f\u0016\u0001%C\u0001\"\u0014\u0005\u0003\u0002\u0003\u0006IA\u0014\u0005\u0006I!!\t!\u0015\u0005\u0006)\"!\t!\u0016\u0005\u0007\u0003\u0003AA\u0011A+\t\r\u00055\u0001\u0002\"\u0001V\u0011\u0019\t\u0019\u0002\u0003C\u0001+\"1\u0011\u0011\u0004\u0005\u0005\u0002UCa!!\t\t\t\u0003)\u0006BBA&\u0011\u0011\u0005Q\u000b\u0003\u0004\u0002P!!\t!\u0016\u0005\u0007\u0003+BA\u0011A+\u0002-\u0005\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f\u001e+fgRT!AF\f\u0002\rM,'O^3s\u0015\u0005A\u0012!B6bM.\f7\u0001\u0001\t\u00037\u0005i\u0011!\u0006\u0002\u0017\u0003BLg+\u001a:tS>t7OU3rk\u0016\u001cH\u000fV3tiN\u0011\u0011A\b\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005Q\u0012AH2p]R\u0014x\u000e\u001c)mC:,G*[:uK:,'\u000f\u0015:pa\u0016\u0014H/[3t)\u0005A\u0003\u0003B\u0015/aAj\u0011A\u000b\u0006\u0003W1\nA!\u001e;jY*\tQ&\u0001\u0003kCZ\f\u0017BA\u0018+\u0005\u001dA\u0015m\u001d5NCB\u0004\"!\r\u001d\u000f\u0005I2\u0004CA\u001a!\u001b\u0005!$BA\u001b\u001a\u0003\u0019a$o\\8u}%\u0011q\u0007I\u0001\u0007!J,G-\u001a4\n\u0005eR$AB*ue&twM\u0003\u00028A\u0005qB/Z:u\u0003BLg+\u001a:tS>t7OU3rk\u0016\u001cH\u000fV3na2\fG/\u001a\u000b\u0002{A\u0019\u0011F\u0010!\n\u0005}R#\u0001\u0002'jgR\u0004\"!\u0011#\u000e\u0003\tS!aQ\f\u0002\tQ,7\u000f^\u0005\u0003\u000b\n\u0013Qb\u00117vgR,'oQ8oM&<\u0017\u0001\u000e;fgR\f\u0005/\u001b,feNLwN\\:SKF,Xm\u001d;J]\u000edW\u000fZ3t+:\u0014X\r\\3bg\u0016$\u0017\t]5t)\u0016l\u0007\u000f\\1uK\u0006QC/Z:u\u0003BLg+\u001a:tS>t7OU3rk\u0016\u001cHOV1mS\u0012\fG/[8o-B\"V-\u001c9mCR,\u0017\u0001\u0006>l\u0003BLg+\u001a:tS>t7OU3rk\u0016\u001cHo\u0005\u0002\t\u0015B\u00111dS\u0005\u0003\u0019V\u0011a$\u00112tiJ\f7\r^!qSZ+'o]5p]N\u0014V-];fgR$Vm\u001d;\u0002\u000f\rdWo\u001d;feB\u0011\u0011iT\u0005\u0003!\n\u0013qb\u00117vgR,'/\u00138ti\u0006t7-\u001a\u000b\u0003%N\u0003\"a\u0007\u0005\t\u000b5S\u0001\u0019\u0001(\u0002-Q,7\u000f^!qSZ+'o]5p]N\u0014V-];fgR$\u0012A\u0016\t\u0003?]K!\u0001\u0017\u0011\u0003\tUs\u0017\u000e\u001e\u0015\u0005\u0017i\u0003\u0017\r\u0005\u0002\\=6\tAL\u0003\u0002^\u0005\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005}c&aD\"mkN$XM\u001d+f[Bd\u0017\r^3\u0002\u000bY\fG.^3\"\u0003mBcaC2gOB\f\bCA.e\u0013\t)GLA\u0006DYV\u001cH/\u001a:UKN$\u0018!\u0002;za\u0016\u001cHF\u00015nI\u0005I\u0017B\u00016l\u0003\u0015Y%+\u0011$U\u0015\taG,\u0001\u0003UsB,G%\u00018\n\u0005=\\\u0017\u0001C\"P?.\u0013\u0016I\u0012+\u0002!M,'O^3s!J|\u0007/\u001a:uS\u0016\u001cHF\u0001:|W\u0015\u0019ho\u001e1z!\tYF/\u0003\u0002v9\n)2\t\\;ti\u0016\u00148i\u001c8gS\u001e\u0004&o\u001c9feRL\u0018aA6fs\u0006\n\u00010\u0001\u000fv]N$\u0018M\u00197f]\u0005\u0004\u0018N\f<feNLwN\\:/K:\f'\r\\3\"\u0003i\fQAZ1mg\u0016\\Sa\u001d<}Az\f\u0013!`\u0001!k:\u001cH/\u00192mK:2W-\u0019;ve\u0016tc/\u001a:tS>t7OL3oC\ndW-I\u0001\u0000\u0003\u0011!(/^3\u0002YQ,7\u000f^!qSZ+'o]5p]N\u0014V-];fgRLen\u00197vI\u0016\u001cXK\u001c:fY\u0016\f7/\u001a3Ba&\u001c\b&\u0002\u0007[A\u0006\u0015\u0011%\u0001$)\u00111\u0019g-!\u0003q\u0003\u0017a#\u0001[7-\u0005I\\\u0018!\r;fgR\f\u0005/\u001b,feNLwN\\:SKF,Xm\u001d;UQJ|Wo\u001a5D_:$(o\u001c7QY\u0006tW\rT5ti\u0016tWM\u001d\u0015\u0006\u001bi\u0003\u0017\u0011C\u0011\u0002\u0011\u0006yC/Z:u\u0003BLg+\u001a:tS>t7OU3rk\u0016\u001cH\u000f\u00165s_V<\u0007nQ8oiJ|G\u000e\\3s\u0019&\u001cH/\u001a8fe\"*ab\u00194\u0002\u00181\n\u0001.\u0001\u0017uKN$\u0018\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u/&$\b.\u00168tkB\u0004xN\u001d;fIZ+'o]5p]\"*qB\u00171\u0002\u0012!*qb\u00194\u0002 1\u0012\u0001.\\\u0001#i\u0016\u001cH/\u00119j-\u0016\u00148/[8ogJ+\u0017/^3tiZ\u000bG.\u001b3bi&|gN\u0016\u0019)\u000bAQ\u0006-!\n\"\u0003\u001dCC\u0002E2g\u0003S\tY#!\fq\u0003\u000fb#\u0001[7\u0002\u001f5,G/\u00193bi\u00064VM]:j_:$#!a\f\n\t\u0005E\u00121G\u0001\f\u0013\n\u0003vlM09?&3\u0006G\u0003\u0003\u00026\u0005]\u0012aD'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8\u000b\t\u0005e\u00121H\u0001\u0007G>lWn\u001c8\u000b\u0007Y\tiDC\u0002\u0019\u0003\u007fQA!!\u0011\u0002D\u00051\u0011\r]1dQ\u0016T!!!\u0012\u0002\u0007=\u0014x\rL\u0002s\u0003\u0013ZSa\u001d<}Af\fQ\b^3ti\u0006\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f\u001e,bY&$\u0017\r^5p]Z\u0003D\u000b\u001b:pk\u001eD7i\u001c8ue>d\u0007\u000b\\1oK2K7\u000f^3oKJDS!\u0005.a\u0003#\t1\b^3ti\u0006\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f\u001e,bY&$\u0017\r^5p]Z\u0003D\u000b\u001b:pk\u001eD7i\u001c8ue>dG.\u001a:MSN$XM\\3sQ\u0015\u00112MZA*Y\u0005A\u0017A\t;fgR\f\u0005/\u001b,feNLwN\\:SKF,Xm\u001d;WC2LG-\u0019;j_:46\u0007K\u0003\u00145\u0002\f\t\u0002K\u0003\u0014G\u001a\fY\u0006\f\u0002i[\"2\u0001\"a\u0018a\u0003o\u0002B!!\u0019\u0002t5\u0011\u00111\r\u0006\u0005\u0003K\n9'A\u0005fqR,gn]5p]*!\u0011\u0011NA6\u0003\r\t\u0007/\u001b\u0006\u0005\u0003[\ny'A\u0004kkBLG/\u001a:\u000b\t\u0005E\u00141I\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003k\n\u0019G\u0001\u0006FqR,g\u000eZ,ji\"d#!!\u001f$\u0005\u0005m\u0004\u0003BA?\u0003\u0003k!!a \u000b\u0007\u0005E$)\u0003\u0003\u0002\u0004\u0006}$!F\"mkN$XM\u001d+fgR,\u0005\u0010^3og&|gn\u001d")
public class ApiVersionsRequestTest
extends AbstractApiVersionsRequestTest {
    private final ClusterInstance cluster;

    public static List<ClusterConfig> zkApiVersionsRequest() {
        return ApiVersionsRequestTest$.MODULE$.zkApiVersionsRequest();
    }

    public static List<ClusterConfig> testApiVersionsRequestValidationV0Template() {
        return ApiVersionsRequestTest$.MODULE$.testApiVersionsRequestValidationV0Template();
    }

    public static List<ClusterConfig> testApiVersionsRequestIncludesUnreleasedApisTemplate() {
        return ApiVersionsRequestTest$.MODULE$.testApiVersionsRequestIncludesUnreleasedApisTemplate();
    }

    public static List<ClusterConfig> testApiVersionsRequestTemplate() {
        return ApiVersionsRequestTest$.MODULE$.testApiVersionsRequestTemplate();
    }

    public static HashMap<String, String> controlPlaneListenerProperties() {
        return ApiVersionsRequestTest$.MODULE$.controlPlaneListenerProperties();
    }

    @ClusterTemplate(value="testApiVersionsRequestTemplate")
    @ClusterTest(types={Type.KRAFT, Type.CO_KRAFT}, serverProperties={@ClusterConfigProperty(key="unstable.api.versions.enable", value="false"), @ClusterConfigProperty(key="unstable.feature.versions.enable", value="true")})
    public void testApiVersionsRequest() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(request, this.cluster.clientListener());
        this.validateApiVersionsResponse(apiVersionsResponse, this.validateApiVersionsResponse$default$2(), this.validateApiVersionsResponse$default$3(), this.validateApiVersionsResponse$default$4(), this.validateApiVersionsResponse$default$5());
    }

    @ClusterTemplate(value="testApiVersionsRequestIncludesUnreleasedApisTemplate")
    @ClusterTest(types={Type.KRAFT, Type.CO_KRAFT}, serverProperties={@ClusterConfigProperty(key="unstable.api.versions.enable", value="false"), @ClusterConfigProperty(key="unstable.feature.versions.enable", value="true")})
    public void testApiVersionsRequestIncludesUnreleasedApis() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(request, this.cluster.clientListener());
        ListenerName x$3 = this.validateApiVersionsResponse$default$2();
        boolean x$4 = this.validateApiVersionsResponse$default$4();
        short x$5 = this.validateApiVersionsResponse$default$5();
        this.validateApiVersionsResponse(apiVersionsResponse, x$3, true, x$4, x$5);
    }

    @ClusterTemplate(value="zkApiVersionsRequest")
    public void testApiVersionsRequestThroughControlPlaneListener() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(request, this.cluster.controlPlaneListenerName().get());
        this.validateApiVersionsResponse(apiVersionsResponse, this.cluster.controlPlaneListenerName().get(), true, this.validateApiVersionsResponse$default$4(), this.validateApiVersionsResponse$default$5());
    }

    @ClusterTest(types={Type.KRAFT})
    public void testApiVersionsRequestThroughControllerListener() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(request, this.cluster.controllerListenerName().get());
        this.validateApiVersionsResponse(apiVersionsResponse, this.cluster.controllerListenerName().get(), this.validateApiVersionsResponse$default$3(), this.validateApiVersionsResponse$default$4(), this.validateApiVersionsResponse$default$5());
    }

    @ClusterTemplate(value="zkApiVersionsRequest")
    @ClusterTest(types={Type.KRAFT, Type.CO_KRAFT})
    public void testApiVersionsRequestWithUnsupportedVersion() {
        ApiVersionsRequest apiVersionsRequest = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendUnsupportedApiVersionRequest(apiVersionsRequest);
        Assertions.assertEquals((short)Errors.UNSUPPORTED_VERSION.code(), (short)apiVersionsResponse.data().errorCode());
        Assertions.assertFalse((boolean)apiVersionsResponse.data().apiKeys().isEmpty());
        ApiVersionsResponseData.ApiVersion apiVersion = apiVersionsResponse.data().apiKeys().find(ApiKeys.API_VERSIONS.id);
        Assertions.assertEquals((short)ApiKeys.API_VERSIONS.id, (short)apiVersion.apiKey());
        Assertions.assertEquals((short)ApiKeys.API_VERSIONS.oldestVersion(), (short)apiVersion.minVersion());
        Assertions.assertEquals((short)ApiKeys.API_VERSIONS.latestVersion(), (short)apiVersion.maxVersion());
    }

    @ClusterTemplate(value="testApiVersionsRequestValidationV0Template")
    @ClusterTest(types={Type.KRAFT, Type.CO_KRAFT}, metadataVersion=MetadataVersion.IBP_3_8_IV0, serverProperties={@ClusterConfigProperty(key="unstable.api.versions.enable", value="false"), @ClusterConfigProperty(key="unstable.feature.versions.enable", value="false")})
    public void testApiVersionsRequestValidationV0() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest.Builder().build((short)0);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, this.cluster.clientListener());
        boolean x$3 = !"false".equals(this.cluster.config().serverProperties().get("unstable.api.versions.enable"));
        ListenerName x$4 = this.validateApiVersionsResponse$default$2();
        boolean x$5 = this.validateApiVersionsResponse$default$4();
        this.validateApiVersionsResponse(apiVersionsResponse, x$4, x$3, x$5, (short)0);
    }

    @ClusterTemplate(value="zkApiVersionsRequest")
    public void testApiVersionsRequestValidationV0ThroughControlPlaneListener() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest.Builder().build((short)0);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, this.cluster.controlPlaneListenerName().get());
        this.validateApiVersionsResponse(apiVersionsResponse, this.cluster.controlPlaneListenerName().get(), true, this.validateApiVersionsResponse$default$4(), this.validateApiVersionsResponse$default$5());
    }

    @ClusterTest(types={Type.KRAFT})
    public void testApiVersionsRequestValidationV0ThroughControllerListener() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest.Builder().build((short)0);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, this.cluster.controllerListenerName().get());
        ListenerName x$2 = this.cluster.controllerListenerName().get();
        boolean x$4 = this.validateApiVersionsResponse$default$3();
        boolean x$5 = this.validateApiVersionsResponse$default$4();
        this.validateApiVersionsResponse(apiVersionsResponse, x$2, x$4, x$5, (short)0);
    }

    @ClusterTemplate(value="zkApiVersionsRequest")
    @ClusterTest(types={Type.KRAFT, Type.CO_KRAFT})
    public void testApiVersionsRequestValidationV3() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest(new ApiVersionsRequestData(), (short)3);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, this.cluster.clientListener());
        Assertions.assertEquals((short)Errors.INVALID_REQUEST.code(), (short)apiVersionsResponse.data().errorCode());
    }

    public ApiVersionsRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
        super(cluster);
    }
}

