/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.generated;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.coordinator.group.generated.GroupMetadataValue;

public class GroupMetadataValueJsonConverter {
    public static GroupMetadataValue read(JsonNode _node, short _version) {
        GroupMetadataValue _object = new GroupMetadataValue();
        JsonNode _protocolTypeNode = _node.get("protocolType");
        if (_protocolTypeNode == null) {
            throw new RuntimeException("GroupMetadataValue: unable to locate field 'protocolType', which is mandatory in version " + _version);
        }
        if (!_protocolTypeNode.isTextual()) {
            throw new RuntimeException("GroupMetadataValue expected a string type, but got " + _node.getNodeType());
        }
        _object.protocolType = _protocolTypeNode.asText();
        JsonNode _generationNode = _node.get("generation");
        if (_generationNode == null) {
            throw new RuntimeException("GroupMetadataValue: unable to locate field 'generation', which is mandatory in version " + _version);
        }
        _object.generation = MessageUtil.jsonNodeToInt((JsonNode)_generationNode, (String)"GroupMetadataValue");
        JsonNode _protocolNode = _node.get("protocol");
        if (_protocolNode == null) {
            throw new RuntimeException("GroupMetadataValue: unable to locate field 'protocol', which is mandatory in version " + _version);
        }
        if (_protocolNode.isNull()) {
            _object.protocol = null;
        } else {
            if (!_protocolNode.isTextual()) {
                throw new RuntimeException("GroupMetadataValue expected a string type, but got " + _node.getNodeType());
            }
            _object.protocol = _protocolNode.asText();
        }
        JsonNode _leaderNode = _node.get("leader");
        if (_leaderNode == null) {
            throw new RuntimeException("GroupMetadataValue: unable to locate field 'leader', which is mandatory in version " + _version);
        }
        if (_leaderNode.isNull()) {
            _object.leader = null;
        } else {
            if (!_leaderNode.isTextual()) {
                throw new RuntimeException("GroupMetadataValue expected a string type, but got " + _node.getNodeType());
            }
            _object.leader = _leaderNode.asText();
        }
        JsonNode _currentStateTimestampNode = _node.get("currentStateTimestamp");
        if (_currentStateTimestampNode == null) {
            if (_version >= 2) {
                throw new RuntimeException("GroupMetadataValue: unable to locate field 'currentStateTimestamp', which is mandatory in version " + _version);
            }
            _object.currentStateTimestamp = -1L;
        } else {
            _object.currentStateTimestamp = MessageUtil.jsonNodeToLong((JsonNode)_currentStateTimestampNode, (String)"GroupMetadataValue");
        }
        JsonNode _membersNode = _node.get("members");
        if (_membersNode == null) {
            throw new RuntimeException("GroupMetadataValue: unable to locate field 'members', which is mandatory in version " + _version);
        }
        if (!_membersNode.isArray()) {
            throw new RuntimeException("GroupMetadataValue expected a JSON array, but got " + _node.getNodeType());
        }
        ArrayList<GroupMetadataValue.MemberMetadata> _collection = new ArrayList<GroupMetadataValue.MemberMetadata>(_membersNode.size());
        _object.members = _collection;
        for (JsonNode _element : _membersNode) {
            _collection.add(MemberMetadataJsonConverter.read(_element, _version));
        }
        return _object;
    }

    public static JsonNode write(GroupMetadataValue _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("protocolType", (JsonNode)new TextNode(_object.protocolType));
        _node.set("generation", (JsonNode)new IntNode(_object.generation));
        if (_object.protocol == null) {
            _node.set("protocol", (JsonNode)NullNode.instance);
        } else {
            _node.set("protocol", (JsonNode)new TextNode(_object.protocol));
        }
        if (_object.leader == null) {
            _node.set("leader", (JsonNode)NullNode.instance);
        } else {
            _node.set("leader", (JsonNode)new TextNode(_object.leader));
        }
        if (_version >= 2) {
            _node.set("currentStateTimestamp", (JsonNode)new LongNode(_object.currentStateTimestamp));
        }
        ArrayNode _membersArray = new ArrayNode(JsonNodeFactory.instance);
        for (GroupMetadataValue.MemberMetadata _element : _object.members) {
            _membersArray.add(MemberMetadataJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("members", (JsonNode)_membersArray);
        return _node;
    }

    public static JsonNode write(GroupMetadataValue _object, short _version) {
        return GroupMetadataValueJsonConverter.write(_object, _version, true);
    }

    public static class MemberMetadataJsonConverter {
        public static GroupMetadataValue.MemberMetadata read(JsonNode _node, short _version) {
            GroupMetadataValue.MemberMetadata _object = new GroupMetadataValue.MemberMetadata();
            JsonNode _memberIdNode = _node.get("memberId");
            if (_memberIdNode == null) {
                throw new RuntimeException("MemberMetadata: unable to locate field 'memberId', which is mandatory in version " + _version);
            }
            if (!_memberIdNode.isTextual()) {
                throw new RuntimeException("MemberMetadata expected a string type, but got " + _node.getNodeType());
            }
            _object.memberId = _memberIdNode.asText();
            JsonNode _groupInstanceIdNode = _node.get("groupInstanceId");
            if (_groupInstanceIdNode == null) {
                if (_version >= 3) {
                    throw new RuntimeException("MemberMetadata: unable to locate field 'groupInstanceId', which is mandatory in version " + _version);
                }
                _object.groupInstanceId = null;
            } else if (_groupInstanceIdNode.isNull()) {
                _object.groupInstanceId = null;
            } else {
                if (!_groupInstanceIdNode.isTextual()) {
                    throw new RuntimeException("MemberMetadata expected a string type, but got " + _node.getNodeType());
                }
                _object.groupInstanceId = _groupInstanceIdNode.asText();
            }
            JsonNode _clientIdNode = _node.get("clientId");
            if (_clientIdNode == null) {
                throw new RuntimeException("MemberMetadata: unable to locate field 'clientId', which is mandatory in version " + _version);
            }
            if (!_clientIdNode.isTextual()) {
                throw new RuntimeException("MemberMetadata expected a string type, but got " + _node.getNodeType());
            }
            _object.clientId = _clientIdNode.asText();
            JsonNode _clientHostNode = _node.get("clientHost");
            if (_clientHostNode == null) {
                throw new RuntimeException("MemberMetadata: unable to locate field 'clientHost', which is mandatory in version " + _version);
            }
            if (!_clientHostNode.isTextual()) {
                throw new RuntimeException("MemberMetadata expected a string type, but got " + _node.getNodeType());
            }
            _object.clientHost = _clientHostNode.asText();
            JsonNode _rebalanceTimeoutNode = _node.get("rebalanceTimeout");
            if (_rebalanceTimeoutNode == null) {
                if (_version >= 1) {
                    throw new RuntimeException("MemberMetadata: unable to locate field 'rebalanceTimeout', which is mandatory in version " + _version);
                }
                _object.rebalanceTimeout = -1;
            } else {
                _object.rebalanceTimeout = MessageUtil.jsonNodeToInt((JsonNode)_rebalanceTimeoutNode, (String)"MemberMetadata");
            }
            JsonNode _sessionTimeoutNode = _node.get("sessionTimeout");
            if (_sessionTimeoutNode == null) {
                throw new RuntimeException("MemberMetadata: unable to locate field 'sessionTimeout', which is mandatory in version " + _version);
            }
            _object.sessionTimeout = MessageUtil.jsonNodeToInt((JsonNode)_sessionTimeoutNode, (String)"MemberMetadata");
            JsonNode _subscriptionNode = _node.get("subscription");
            if (_subscriptionNode == null) {
                throw new RuntimeException("MemberMetadata: unable to locate field 'subscription', which is mandatory in version " + _version);
            }
            _object.subscription = MessageUtil.jsonNodeToBinary((JsonNode)_subscriptionNode, (String)"MemberMetadata");
            JsonNode _assignmentNode = _node.get("assignment");
            if (_assignmentNode == null) {
                throw new RuntimeException("MemberMetadata: unable to locate field 'assignment', which is mandatory in version " + _version);
            }
            _object.assignment = MessageUtil.jsonNodeToBinary((JsonNode)_assignmentNode, (String)"MemberMetadata");
            return _object;
        }

        public static JsonNode write(GroupMetadataValue.MemberMetadata _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("memberId", (JsonNode)new TextNode(_object.memberId));
            if (_version >= 3) {
                if (_object.groupInstanceId == null) {
                    _node.set("groupInstanceId", (JsonNode)NullNode.instance);
                } else {
                    _node.set("groupInstanceId", (JsonNode)new TextNode(_object.groupInstanceId));
                }
            }
            _node.set("clientId", (JsonNode)new TextNode(_object.clientId));
            _node.set("clientHost", (JsonNode)new TextNode(_object.clientHost));
            if (_version >= 1) {
                _node.set("rebalanceTimeout", (JsonNode)new IntNode(_object.rebalanceTimeout));
            }
            _node.set("sessionTimeout", (JsonNode)new IntNode(_object.sessionTimeout));
            _node.set("subscription", (JsonNode)new BinaryNode(Arrays.copyOf(_object.subscription, _object.subscription.length)));
            _node.set("assignment", (JsonNode)new BinaryNode(Arrays.copyOf(_object.assignment, _object.assignment.length)));
            return _node;
        }

        public static JsonNode write(GroupMetadataValue.MemberMetadata _object, short _version) {
            return MemberMetadataJsonConverter.write(_object, _version, true);
        }
    }
}

