/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.consumer;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.api.assignor.SubscribedTopicDescriber;
import org.apache.kafka.coordinator.group.consumer.TopicMetadata;

public class SubscribedTopicDescriberImpl
implements SubscribedTopicDescriber {
    private final Map<Uuid, TopicMetadata> topicMetadata;

    public SubscribedTopicDescriberImpl(Map<Uuid, TopicMetadata> topicMetadata) {
        this.topicMetadata = Objects.requireNonNull(topicMetadata);
    }

    public Map<Uuid, TopicMetadata> topicMetadata() {
        return this.topicMetadata;
    }

    public int numPartitions(Uuid topicId) {
        TopicMetadata topic = this.topicMetadata.get(topicId);
        return topic == null ? -1 : topic.numPartitions();
    }

    public Set<String> racksForPartition(Uuid topicId, int partition) {
        TopicMetadata topic = this.topicMetadata.get(topicId);
        return topic == null ? Collections.emptySet() : topic.partitionRacks().getOrDefault(partition, Collections.emptySet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscribedTopicDescriberImpl that = (SubscribedTopicDescriberImpl)o;
        return this.topicMetadata.equals(that.topicMetadata);
    }

    public int hashCode() {
        return this.topicMetadata.hashCode();
    }

    public String toString() {
        return "SubscribedTopicMetadata(topicMetadata=" + this.topicMetadata + ')';
    }
}

