/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.redirect;

import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.model.OAuth1RequestToken;
import com.github.scribejava.core.oauth.OAuth10aService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.HttpCommunicationException;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.exception.http.RedirectionAction;
import org.pac4j.core.redirect.RedirectionActionBuilder;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpActionHelper;
import org.pac4j.oauth.config.OAuth10Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth10RedirectionActionBuilder
implements RedirectionActionBuilder {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth10RedirectionActionBuilder.class);
    protected OAuth10Configuration configuration;
    protected IndirectClient client;

    public OAuth10RedirectionActionBuilder(OAuth10Configuration configuration, IndirectClient client) {
        CommonHelper.assertNotNull((String)"client", (Object)client);
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)configuration));
        this.configuration = configuration;
        this.client = client;
    }

    public Optional<RedirectionAction> getRedirectionAction(CallContext ctx) {
        try {
            OAuth1RequestToken requestToken;
            WebContext webContext = ctx.webContext();
            OAuth10aService service = (OAuth10aService)this.configuration.buildService(webContext, this.client);
            try {
                requestToken = service.getRequestToken();
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                throw new HttpCommunicationException("Error getting token: " + e.getMessage());
            }
            LOGGER.debug("requestToken: {}", (Object)requestToken);
            ctx.sessionStore().set(webContext, this.configuration.getRequestTokenSessionAttributeName(this.client.getName()), (Object)requestToken);
            String authorizationUrl = service.getAuthorizationUrl(requestToken);
            LOGGER.debug("authorizationUrl: {}", (Object)authorizationUrl);
            return Optional.of(HttpActionHelper.buildRedirectUrlAction((WebContext)webContext, (String)authorizationUrl));
        }
        catch (OAuthException e) {
            throw new TechnicalException((Throwable)e);
        }
    }
}

