/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.passwordless;

import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.api.PasswordlessAuthenticationRequest;
import org.apereo.cas.api.PasswordlessRequestParser;
import org.apereo.cas.authentication.MutableCredential;
import org.apereo.cas.authentication.credential.BasicIdentifiableCredential;
import org.apereo.cas.authentication.surrogate.SurrogateAuthenticationRequest;
import org.apereo.cas.authentication.surrogate.SurrogateCredentialParser;
import org.apereo.cas.util.CollectionUtils;

public class SurrogatePasswordlessAuthenticationRequestParser
implements PasswordlessRequestParser {
    public static final String PROPERTY_SURROGATE_USERNAME = "surrogateUsername";
    private final SurrogateCredentialParser surrogateCredentialParser;

    public PasswordlessAuthenticationRequest parse(String username) {
        BasicIdentifiableCredential credential = new BasicIdentifiableCredential(username);
        Optional result = this.surrogateCredentialParser.parse((MutableCredential)credential);
        if (result.isPresent()) {
            SurrogateAuthenticationRequest sr = (SurrogateAuthenticationRequest)result.get();
            return PasswordlessAuthenticationRequest.builder().providedUsername(username).username(sr.getUsername()).properties(CollectionUtils.wrap((String)PROPERTY_SURROGATE_USERNAME, (Object)sr.getSurrogateUsername())).build();
        }
        return PasswordlessAuthenticationRequest.builder().username(username).build();
    }

    @Generated
    public SurrogatePasswordlessAuthenticationRequestParser(SurrogateCredentialParser surrogateCredentialParser) {
        this.surrogateCredentialParser = surrogateCredentialParser;
    }
}

