/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.core;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.yubico.data.CredentialRegistration;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.webauthn.storage.BaseWebAuthnCredentialRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryRegistrationStorage
extends BaseWebAuthnCredentialRepository {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(InMemoryRegistrationStorage.class);
    private final Cache<String, Set<CredentialRegistration>> storage = Caffeine.newBuilder().maximumSize(5000L).expireAfterAccess(1L, TimeUnit.DAYS).build();

    public InMemoryRegistrationStorage(CasConfigurationProperties properties, CipherExecutor<String, String> cipherExecutor) {
        super(properties, cipherExecutor);
    }

    @Override
    public boolean addRegistrationByUsername(String username, CredentialRegistration reg) {
        return (Boolean)FunctionUtils.doUnchecked(() -> ((Set)this.storage.get((Object)username.toLowerCase(Locale.ENGLISH), __ -> new HashSet())).add(reg));
    }

    @Override
    public Collection<CredentialRegistration> getRegistrationsByUsername(String username) {
        return (Collection)FunctionUtils.doUnchecked(() -> (Set)this.storage.get((Object)username.toLowerCase(Locale.ENGLISH), __ -> new HashSet()));
    }

    @Override
    public boolean removeRegistrationByUsername(String username, CredentialRegistration credentialRegistration) {
        return (Boolean)FunctionUtils.doUnchecked(() -> ((Set)this.storage.get((Object)username.toLowerCase(Locale.ENGLISH), __ -> new HashSet())).remove(credentialRegistration));
    }

    @Override
    public boolean removeAllRegistrations(String username) {
        this.storage.invalidate((Object)username.toLowerCase(Locale.ENGLISH));
        return true;
    }

    @Override
    public Stream<? extends CredentialRegistration> stream() {
        return this.storage.asMap().values().stream().flatMap(Collection::stream);
    }

    @Override
    protected void update(String username, Collection<CredentialRegistration> records) {
        this.storage.put((Object)username.toLowerCase(Locale.ENGLISH), new LinkedHashSet<CredentialRegistration>(records));
    }

    @Generated
    public Cache<String, Set<CredentialRegistration>> getStorage() {
        return this.storage;
    }
}

