/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.Phase;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.passthru.Pipe;
import org.apache.synapse.transport.passthru.config.PassThroughConfiguration;
import org.apache.synapse.transport.passthru.util.DeferredMessageBuilder;
import org.apache.synapse.transport.passthru.util.PassThroughTransportUtils;
import org.apache.synapse.transport.passthru.util.RelayConstants;
import org.apache.synapse.transport.passthru.util.StreamingOnRequestDataSource;

public class RelayUtils {
    private static final Log log = LogFactory.getLog(RelayUtils.class);
    private static final DeferredMessageBuilder messageBuilder = new DeferredMessageBuilder();
    private static volatile Handler addressingInHandler = null;
    private static boolean noAddressingHandler = false;
    private static Boolean forcePTBuild = null;

    public static void buildMessage(MessageContext msgCtx) throws IOException, XMLStreamException {
        RelayUtils.buildMessage(msgCtx, false);
    }

    public static void buildMessage(MessageContext messageContext, boolean earlyBuild) throws IOException, XMLStreamException {
        OMElement contentEle;
        OMNode node;
        Pipe pipe = (Pipe)messageContext.getProperty("pass-through.pipe");
        if (pipe != null && forcePTBuild.booleanValue() && !PassThroughTransportUtils.builderInvoked(messageContext)) {
            InputStream in = pipe.getInputStream();
            RelayUtils.buildMessage(messageContext, earlyBuild, in);
            return;
        }
        SOAPEnvelope envelope = messageContext.getEnvelope();
        QName firstElementQName = envelope.getSOAPBodyFirstElementNS() != null ? new QName(envelope.getSOAPBodyFirstElementNS().getNamespaceURI(), envelope.getSOAPBodyFirstElementLocalName()) : (envelope.getSOAPBodyFirstElementLocalName() != null ? new QName(envelope.getSOAPBodyFirstElementLocalName()) : null);
        if (RelayConstants.BINARY_CONTENT_QNAME.equals(firstElementQName) && (node = (contentEle = envelope.getBody().getFirstElement()).getFirstOMChild()) != null && node instanceof OMText) {
            InputStream in;
            OMElement element;
            OMText binaryDataNode = (OMText)node;
            DataHandler dh = (DataHandler)binaryDataNode.getDataHandler();
            if (dh == null) {
                throw new AxisFault("Error while building message");
            }
            DataSource dataSource = dh.getDataSource();
            if (dataSource instanceof StreamingOnRequestDataSource) {
                ((StreamingOnRequestDataSource)dataSource).setLastUse(true);
            }
            if ((element = messageBuilder.getDocument(messageContext, in = dh.getInputStream())) != null) {
                messageContext.setEnvelope(TransportUtils.createSOAPEnvelope((OMElement)element));
                messageContext.setProperty("__RELAY_FORMATTERS_MAP", messageBuilder.getFormatters());
                if (!earlyBuild) {
                    RelayUtils.processAddressing(messageContext);
                }
            }
        }
    }

    private static void buildMessage(MessageContext messageContext, boolean earlyBuild, InputStream in) throws IOException {
        BufferedInputStream bufferedInputStream = (BufferedInputStream)messageContext.getProperty("bufferedInputStream");
        if (bufferedInputStream != null) {
            try {
                bufferedInputStream.reset();
                bufferedInputStream.mark(0);
            }
            catch (Exception exception) {}
        } else {
            bufferedInputStream = new BufferedInputStream(in);
            bufferedInputStream.mark(131072);
            messageContext.setProperty("bufferedInputStream", (Object)bufferedInputStream);
        }
        OMElement element = null;
        try {
            element = messageBuilder.getDocument(messageContext, bufferedInputStream);
        }
        catch (Exception e) {
            RelayUtils.consumeAndDiscardMessage(messageContext);
            messageContext.setProperty("message.builder.invoked", (Object)Boolean.TRUE);
            RelayUtils.handleException("Error while building Passthrough stream", e);
        }
        if (element != null) {
            messageContext.setEnvelope(TransportUtils.createSOAPEnvelope((OMElement)element));
            messageContext.setProperty("__RELAY_FORMATTERS_MAP", messageBuilder.getFormatters());
            messageContext.setProperty("message.builder.invoked", (Object)Boolean.TRUE);
            if (!earlyBuild) {
                RelayUtils.processAddressing(messageContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processAddressing(MessageContext messageContext) throws AxisFault {
        Boolean disableAck;
        Object requestResponseTransport;
        if (noAddressingHandler) {
            return;
        }
        if (addressingInHandler == null) {
            DeferredMessageBuilder deferredMessageBuilder = messageBuilder;
            synchronized (deferredMessageBuilder) {
                if (addressingInHandler == null) {
                    AxisConfiguration axisConfig = messageContext.getConfigurationContext().getAxisConfiguration();
                    List phases = axisConfig.getInFlowPhases();
                    boolean handlerFound = false;
                    block3: for (Phase phase : phases) {
                        if (!"Addressing".equals(phase.getName())) continue;
                        List handlers = phase.getHandlers();
                        for (Handler handler : handlers) {
                            if (!"AddressingInHandler".equals(handler.getName())) continue;
                            addressingInHandler = handler;
                            handlerFound = true;
                            break block3;
                        }
                    }
                    if (!handlerFound) {
                        noAddressingHandler = true;
                        return;
                    }
                }
            }
        }
        messageContext.setProperty("disableAddressingForInMessages", (Object)"false");
        Object disableAddressingForOutGoing = null;
        if (messageContext.getProperty("disableAddressingForOutMessages") != null) {
            disableAddressingForOutGoing = messageContext.getProperty("disableAddressingForOutMessages");
        }
        addressingInHandler.invoke(messageContext);
        if (disableAddressingForOutGoing != null) {
            messageContext.setProperty("disableAddressingForOutMessages", disableAddressingForOutGoing);
        }
        if (messageContext.getAxisOperation() == null) {
            return;
        }
        String mepString = messageContext.getAxisOperation().getMessageExchangePattern();
        if (RelayUtils.isOneWay(mepString)) {
            Boolean disableAck2;
            requestResponseTransport = messageContext.getProperty("RequestResponseTransportControl");
            if (!(requestResponseTransport == null || (disableAck2 = RelayUtils.getDisableAck(messageContext)) != null && disableAck2.booleanValue())) {
                ((RequestResponseTransport)requestResponseTransport).acknowledgeMessage(messageContext);
            }
        } else if (AddressingHelper.isReplyRedirected((MessageContext)messageContext) && AddressingHelper.isFaultRedirected((MessageContext)messageContext) && "http://www.w3.org/ns/wsdl/in-out".equals(mepString) && (requestResponseTransport = messageContext.getProperty("RequestResponseTransportControl")) != null && ((disableAck = RelayUtils.getDisableAck(messageContext)) == null || !disableAck.booleanValue())) {
            ((RequestResponseTransport)requestResponseTransport).acknowledgeMessage(messageContext);
        }
    }

    private static Boolean getDisableAck(MessageContext msgContext) throws AxisFault {
        Boolean disableAck = (Boolean)msgContext.getProperty("DisableResponseAck");
        if (disableAck == null) {
            disableAck = (Boolean)(msgContext.getAxisService() != null ? msgContext.getAxisService().getParameterValue("DisableResponseAck") : null);
        }
        return disableAck;
    }

    private static boolean isOneWay(String mepString) {
        return "http://www.w3.org/ns/wsdl/in-only".equals(mepString);
    }

    private static void consumeAndDiscardMessage(MessageContext msgContext) throws AxisFault {
        InputStream in;
        Pipe pipe = (Pipe)msgContext.getProperty("pass-through.pipe");
        if (pipe != null && (in = pipe.getInputStream()) != null) {
            try {
                if (pipe.isConsumeRequired()) {
                    IOUtils.copy((InputStream)in, (OutputStream)new NullOutputStream());
                }
            }
            catch (IOException exception) {
                RelayUtils.handleException("Error when consuming the input stream to discard ", exception);
            }
        }
    }

    private static void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    static {
        if (forcePTBuild == null && (forcePTBuild = PassThroughConfiguration.getInstance().getBooleanProperty("force.passthrough.builder")) == null) {
            forcePTBuild = true;
        }
    }
}

