/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.evaluators.config;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.evaluators.Condition;
import org.apache.synapse.commons.evaluators.Evaluator;
import org.apache.synapse.commons.evaluators.EvaluatorException;
import org.apache.synapse.commons.evaluators.config.EvaluatorFactory;
import org.apache.synapse.commons.evaluators.config.EvaluatorFactoryFinder;

public class ConditionFactory {
    private Log log = LogFactory.getLog(ConditionFactory.class);

    public Condition createCondition(OMElement ruleElement) throws EvaluatorException {
        Condition r = new Condition();
        OMAttribute priorityAtt = ruleElement.getAttribute(new QName("priority"));
        if (priorityAtt != null) {
            int p = Integer.parseInt(priorityAtt.getAttributeValue());
            r.setPriority(p);
        }
        OMElement ce = ruleElement.getFirstElement();
        EvaluatorFactory ef = EvaluatorFactoryFinder.getInstance().findEvaluatorFactory(ce.getLocalName());
        if (ef == null) {
            this.handleException("Invalid configuration element: " + ce.getLocalName());
            return null;
        }
        Evaluator evaluator = ef.create(ce);
        r.setEvaluator(evaluator);
        return r;
    }

    private void handleException(String message) throws EvaluatorException {
        this.log.error((Object)message);
        throw new EvaluatorException(message);
    }
}

