/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.attachments;

import java.io.File;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.attachments.CachedFileDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMText;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AttachmentUtils {
    private static final Log log = LogFactory.getLog(AttachmentUtils.class);
    private static final QName XOP_INCLUDE = new QName("http://www.w3.org/2004/08/xop/include", "Include");

    public static OMText makeBinaryOMNode(OMElement xop, DataHandler dh) {
        OMFactory factory = xop.getOMFactory();
        OMText binaryNode = factory.createOMText((Object)dh, true);
        return binaryNode;
    }

    public static OMElement makeXopElement(OMText data) {
        OMFactory factory = data.getOMFactory();
        OMElement xop = factory.createOMElement(XOP_INCLUDE, null);
        xop.addAttribute("href", data.getContentID(), null);
        return xop;
    }

    public static void findCachedAttachment(Attachments attachments) {
        if (attachments == null) {
            return;
        }
        String[] contentIds = attachments.getAllContentIDs();
        if (contentIds.length > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Attachments exist....");
            }
            String rootContentId = attachments.getRootPartContentID();
            for (String contentId : contentIds) {
                DataHandler dh;
                if (contentId.equals(rootContentId) || (dh = attachments.getDataHandler(contentId)) == null) continue;
                DataSource dataSource = dh.getDataSource();
                if (dh == null || !(dataSource instanceof CachedFileDataSource)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Attachment's DataHandler uses CachedFileDataSource...");
                }
                File file = ((CachedFileDataSource)dataSource).getFile();
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" Making file.deleteOnExit() request on " + file.getAbsolutePath()));
                }
                file.deleteOnExit();
            }
        }
    }
}

