/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

public final class ReplicationStream
extends ObjectInputStream {
    private ClassLoader[] classLoaders = null;

    public ReplicationStream(InputStream stream, ClassLoader[] classLoaders) throws IOException {
        super(stream);
        this.classLoaders = classLoaders;
    }

    public Class resolveClass(ObjectStreamClass classDesc) throws ClassNotFoundException, IOException {
        String name = classDesc.getName();
        boolean tryRepFirst = name.startsWith("org.apache.catalina.tribes");
        try {
            try {
                if (tryRepFirst) {
                    return this.findReplicationClass(name);
                }
                return this.findExternalClass(name);
            }
            catch (Exception x) {
                if (tryRepFirst) {
                    return this.findExternalClass(name);
                }
                return this.findReplicationClass(name);
            }
        }
        catch (ClassNotFoundException e) {
            return super.resolveClass(classDesc);
        }
    }

    public Class findReplicationClass(String name) throws ClassNotFoundException, IOException {
        Class<?> clazz = Class.forName(name, false, this.getClass().getClassLoader());
        return clazz;
    }

    public Class findExternalClass(String name) throws ClassNotFoundException {
        ClassNotFoundException cnfe = null;
        for (int i = 0; i < this.classLoaders.length; ++i) {
            try {
                Class<?> clazz = Class.forName(name, false, this.classLoaders[i]);
                return clazz;
            }
            catch (ClassNotFoundException x) {
                cnfe = x;
                continue;
            }
        }
        if (cnfe != null) {
            throw cnfe;
        }
        throw new ClassNotFoundException(name);
    }

    public void close() throws IOException {
        this.classLoaders = null;
        super.close();
    }
}

