/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.message.store.InMemoryMessageStore;
import org.apache.synapse.message.store.MessageStore;

public class MessageStoreFactory {
    private static final Log log = LogFactory.getLog(MessageStoreFactory.class);
    public static final QName CLASS_Q = new QName("", "class");
    public static final QName NAME_Q = new QName("", "name");
    public static final QName SEQUENCE_Q = new QName("", "sequence");
    public static final QName PARAMETER_Q = new QName("http://ws.apache.org/ns/synapse", "parameter");
    private static final QName DESCRIPTION_Q = new QName("http://ws.apache.org/ns/synapse", "description");

    public static MessageStore createMessageStore(OMElement elem, Properties properties) {
        MessageStore messageStore;
        OMAttribute clss = elem.getAttribute(CLASS_Q);
        if (clss != null) {
            try {
                Class<?> cls = Class.forName(clss.getAttributeValue());
                messageStore = (MessageStore)cls.newInstance();
            }
            catch (Exception e) {
                MessageStoreFactory.handleException("Error while instantiating the message store", e);
                return null;
            }
        } else {
            messageStore = new InMemoryMessageStore();
        }
        OMAttribute nameAtt = elem.getAttribute(NAME_Q);
        if (nameAtt != null) {
            messageStore.setName(nameAtt.getAttributeValue());
        } else {
            MessageStoreFactory.handleException("Message Store name not specified");
        }
        OMElement descriptionElem = elem.getFirstChildWithName(DESCRIPTION_Q);
        if (descriptionElem != null) {
            messageStore.setDescription(descriptionElem.getText());
        }
        messageStore.setParameters(MessageStoreFactory.getParameters(elem));
        log.info((Object)("Successfully created Message Store: " + nameAtt.getAttributeValue()));
        return messageStore;
    }

    private static Map<String, Object> getParameters(OMElement elem) {
        Iterator params = elem.getChildrenWithName(PARAMETER_Q);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        while (params.hasNext()) {
            Object o = params.next();
            if (!(o instanceof OMElement)) continue;
            OMElement prop = (OMElement)o;
            OMAttribute paramName = prop.getAttribute(NAME_Q);
            String paramValue = prop.getText();
            if (paramName != null) {
                if (paramValue == null) continue;
                parameters.put(paramName.getAttributeValue(), paramValue);
                continue;
            }
            MessageStoreFactory.handleException("Invalid MessageStore parameter - Parameter must have a name ");
        }
        return parameters;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }
}

