/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.jaxws.ClientConfigurationFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.ResolvedHandlersDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.JAXWSRIWSDLGenerator;
import org.apache.axis2.jaxws.description.impl.DescriptionFactoryImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.SchemaBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptionFactory {
    private static final Log log = LogFactory.getLog(DescriptionFactory.class);

    private DescriptionFactory() {
    }

    public static ServiceDescription createServiceDescription(URL wsdlURL, QName serviceQName, Class serviceClass) {
        return DescriptionFactoryImpl.createServiceDescription(wsdlURL, serviceQName, serviceClass);
    }

    public static ServiceDescription createServiceDescription(URL wsdlURL, QName serviceQName, Class serviceClass, DescriptionBuilderComposite sparseComposite, Object sparseCompositeKey) {
        return DescriptionFactoryImpl.createServiceDescription(wsdlURL, serviceQName, serviceClass, sparseComposite, sparseCompositeKey);
    }

    public static EndpointDescription updateEndpoint(ServiceDescription serviceDescription, Class sei, QName portQName, UpdateType updateType) {
        return DescriptionFactoryImpl.updateEndpoint(serviceDescription, sei, portQName, updateType, null, null);
    }

    public static EndpointDescription updateEndpoint(ServiceDescription serviceDescription, Class sei, QName portQName, UpdateType updateType, Object serviceDelegateKey) {
        return DescriptionFactoryImpl.updateEndpoint(serviceDescription, sei, portQName, updateType, serviceDelegateKey, null, null);
    }

    public static EndpointDescription updateEndpoint(ServiceDescription serviceDescription, Class sei, QName portQName, UpdateType updateType, DescriptionBuilderComposite composite, Object sparseCompositeKey) {
        return DescriptionFactoryImpl.updateEndpoint(serviceDescription, sei, portQName, updateType, composite, sparseCompositeKey, null, null);
    }

    public static EndpointDescription updateEndpoint(ServiceDescription serviceDescription, Class sei, EndpointReference epr, String addressingNamespace, UpdateType updateType) {
        return DescriptionFactoryImpl.updateEndpoint(serviceDescription, sei, epr, addressingNamespace, updateType, null, null);
    }

    public static EndpointDescription updateEndpoint(ServiceDescription serviceDescription, Class sei, EndpointReference epr, String addressingNamespace, UpdateType updateType, Object serviceDelegateKey) {
        return DescriptionFactoryImpl.updateEndpoint(serviceDescription, sei, epr, addressingNamespace, updateType, serviceDelegateKey, null, null);
    }

    public static EndpointDescription updateEndpoint(ServiceDescription serviceDescription, Class sei, EndpointReference epr, String addressingNamespace, UpdateType updateType, DescriptionBuilderComposite composite, Object sparseCompositeKey) {
        return DescriptionFactoryImpl.updateEndpoint(serviceDescription, sei, epr, addressingNamespace, updateType, composite, sparseCompositeKey, null, null);
    }

    public static EndpointDescription updateEndpoint(ServiceDescription serviceDescription, Class sei, QName portQName, UpdateType updateType, String bindingId, String endpointAddress) {
        return DescriptionFactoryImpl.updateEndpoint(serviceDescription, sei, portQName, updateType, bindingId, endpointAddress);
    }

    public static EndpointDescription updateEndpoint(ServiceDescription serviceDescription, Class sei, QName portQName, UpdateType updateType, Object serviceDelegateKey, String bindingId, String endpointAddress) {
        return DescriptionFactoryImpl.updateEndpoint(serviceDescription, sei, portQName, updateType, serviceDelegateKey, bindingId, endpointAddress);
    }

    public static EndpointDescription updateEndpoint(ServiceDescription serviceDescription, Class sei, QName portQName, UpdateType updateType, DescriptionBuilderComposite composite, Object sparseCompositeKey, String bindingId, String endpointAddress) {
        return DescriptionFactoryImpl.updateEndpoint(serviceDescription, sei, portQName, updateType, composite, sparseCompositeKey, bindingId, endpointAddress);
    }

    public static EndpointDescription updateEndpoint(ServiceDescription serviceDescription, Class sei, EndpointReference epr, String addressingNamespace, UpdateType updateType, String bindingId, String endpointAddress) {
        return DescriptionFactoryImpl.updateEndpoint(serviceDescription, sei, epr, addressingNamespace, updateType, bindingId, endpointAddress);
    }

    public static EndpointDescription updateEndpoint(ServiceDescription serviceDescription, Class sei, EndpointReference epr, String addressingNamespace, UpdateType updateType, Object serviceDelegateKey, String bindingId, String endpointAddress) {
        return DescriptionFactoryImpl.updateEndpoint(serviceDescription, sei, epr, addressingNamespace, updateType, serviceDelegateKey, bindingId, endpointAddress);
    }

    public static EndpointDescription updateEndpoint(ServiceDescription serviceDescription, Class sei, EndpointReference epr, String addressingNamespace, UpdateType updateType, DescriptionBuilderComposite composite, Object sparseCompositeKey, String bindingId, String endpointAddress) {
        return DescriptionFactoryImpl.updateEndpoint(serviceDescription, sei, epr, addressingNamespace, updateType, composite, sparseCompositeKey, bindingId, endpointAddress);
    }

    public static List<ServiceDescription> createServiceDescriptionFromDBCMap(HashMap<String, DescriptionBuilderComposite> dbcMap) {
        SchemaBuilder.initCache();
        List<ServiceDescription> listSD = DescriptionFactoryImpl.createServiceDescriptionFromDBCMap(dbcMap, null);
        SchemaBuilder.clearCache();
        return listSD;
    }

    public static List<ServiceDescription> createServiceDescriptionFromDBCMap(HashMap<String, DescriptionBuilderComposite> dbcMap, ConfigurationContext configContext) {
        return DescriptionFactoryImpl.createServiceDescriptionFromDBCMap(dbcMap, configContext);
    }

    public static List<ServiceDescription> createServiceDescriptionFromDBCMap(HashMap<String, DescriptionBuilderComposite> dbcMap, ConfigurationContext configContext, boolean performVaidation) {
        return DescriptionFactoryImpl.createServiceDescriptionFromDBCMap(dbcMap, configContext, performVaidation);
    }

    public static ServiceDescription createServiceDescription(Class serviceImplClass) {
        return DescriptionFactoryImpl.createServiceDescription(serviceImplClass);
    }

    public static AxisService createAxisService(Class serviceImplClass) {
        return DescriptionFactory.createAxisService(serviceImplClass, null);
    }

    public static AxisService createAxisService(Class serviceImplClass, ConfigurationContext configContext) {
        ServiceDescription serviceDescription = DescriptionFactoryImpl.createServiceDescription(serviceImplClass, configContext);
        EndpointDescription[] edArray = serviceDescription.getEndpointDescriptions();
        AxisService axisService = edArray[0].getAxisService();
        Parameter param = axisService.getParameter("usedAnnotationsOnly");
        if (param != null && "true".equals(param.getValue())) {
            try {
                JAXWSRIWSDLGenerator value = new JAXWSRIWSDLGenerator(axisService);
                axisService.addParameter("WSDLSupplier", (Object)value);
                axisService.addParameter("SchemaSupplier", (Object)value);
            }
            catch (Exception ex) {
                log.info((Object)"Unable to set the WSDLSupplier", (Throwable)ex);
            }
        }
        return axisService;
    }

    public static ClientConfigurationFactory createClientConfigurationFactory() {
        return DescriptionFactoryImpl.getClientConfigurationFactory();
    }

    public static ResolvedHandlersDescription createResolvedHandlersDescription() {
        return DescriptionFactoryImpl.createResolvedHandlersDescription();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UpdateType {
        GET_PORT,
        ADD_PORT,
        CREATE_DISPATCH;

    }
}

