/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.factory;

import java.util.Map;
import org.apache.struts2.ObjectFactory;
import org.apache.struts2.config.ConfigurationException;
import org.apache.struts2.config.entities.ResultConfig;
import org.apache.struts2.factory.ResultFactory;
import org.apache.struts2.inject.Inject;
import org.apache.struts2.result.ParamNameAwareResult;
import org.apache.struts2.result.Result;
import org.apache.struts2.util.reflection.ReflectionException;
import org.apache.struts2.util.reflection.ReflectionExceptionHandler;
import org.apache.struts2.util.reflection.ReflectionProvider;

public class StrutsResultFactory
implements ResultFactory {
    protected ObjectFactory objectFactory;
    protected ReflectionProvider reflectionProvider;

    @Inject
    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    @Inject
    public void setReflectionProvider(ReflectionProvider provider) {
        this.reflectionProvider = provider;
    }

    @Override
    public Result buildResult(ResultConfig resultConfig, Map<String, Object> extraContext) throws Exception {
        String resultClassName = resultConfig.getClassName();
        if (resultClassName == null) {
            return null;
        }
        Object o = this.objectFactory.buildBean(resultClassName, extraContext);
        if (!(o instanceof Result)) {
            throw new ConfigurationException("Class [" + resultClassName + "] does not implement Result", (Object)resultConfig);
        }
        Result result = (Result)o;
        Map<String, String> params = resultConfig.getParams();
        if (params != null) {
            this.setParameters(extraContext, result, params);
        }
        return result;
    }

    protected void setParameters(Map<String, Object> extraContext, Result result, Map<String, String> params) {
        for (Map.Entry<String, String> paramEntry : params.entrySet()) {
            try {
                String name = paramEntry.getKey();
                String value = paramEntry.getValue();
                this.setParameter(result, name, value, extraContext);
            }
            catch (ReflectionException ex) {
                if (!(result instanceof ReflectionExceptionHandler)) continue;
                ReflectionExceptionHandler reflectionExceptionHandler = (ReflectionExceptionHandler)((Object)result);
                reflectionExceptionHandler.handle(ex);
            }
        }
    }

    protected void setParameter(Result result, String name, String value, Map<String, Object> extraContext) {
        ParamNameAwareResult paramNameAwareResult;
        if (!(result instanceof ParamNameAwareResult) || (paramNameAwareResult = (ParamNameAwareResult)((Object)result)).acceptableParameterName(name, value)) {
            this.reflectionProvider.setProperty(name, value, result, extraContext, true);
        }
    }
}

