/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.tiles;

import jakarta.servlet.http.HttpServletRequest;
import ognl.OgnlException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ActionContext;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.config.ConfigurationException;
import org.apache.struts2.ognl.OgnlUtil;
import org.apache.tiles.core.evaluator.AbstractAttributeEvaluator;
import org.apache.tiles.core.evaluator.EvaluationException;
import org.apache.tiles.request.Request;
import org.apache.tiles.request.servlet.ServletUtil;

public class StrutsAttributeEvaluator
extends AbstractAttributeEvaluator {
    private static final Logger LOG = LogManager.getLogger(StrutsAttributeEvaluator.class);

    @Override
    public Object evaluate(String expression, Request request) {
        try {
            HttpServletRequest httpRequest = ServletUtil.getServletRequest(request).getRequest();
            ActionContext ctx = ServletActionContext.getActionContext((HttpServletRequest)httpRequest);
            if (ctx == null) {
                LOG.error("Cannot obtain HttpServletRequest from [{}]", (Object)request.getClass().getName());
                throw new ConfigurationException("There is no ActionContext for current request!");
            }
            OgnlUtil ognlUtil = (OgnlUtil)ctx.getContainer().getInstance(OgnlUtil.class);
            LOG.debug("Trying evaluate expression [{}] using OgnlUtil's getValue", (Object)expression);
            Object result = ognlUtil.getValue(expression, ctx.getContextMap(), (Object)ctx.getValueStack().getRoot());
            LOG.debug("Final result of evaluating expression [{}] is: {}", (Object)expression, result);
            return result;
        }
        catch (OgnlException e) {
            throw new EvaluationException(e);
        }
    }
}

