/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher.multipart;

import http.utils.multipartrequest.MultipartRequest;
import http.utils.multipartrequest.ServletMultipartRequest;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.dispatcher.multipart.AbstractMultiPartRequest;
import org.apache.struts2.dispatcher.multipart.StrutsUploadedFile;
import org.apache.struts2.dispatcher.multipart.UploadedFile;

public class PellMultiPartRequest
extends AbstractMultiPartRequest {
    private static final Logger LOG = LogManager.getLogger(PellMultiPartRequest.class);
    private ServletMultipartRequest multi;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(HttpServletRequest servletRequest, String saveDir) throws IOException {
        PellMultiPartRequest pellMultiPartRequest = this;
        synchronized (pellMultiPartRequest) {
            this.setEncoding();
            if (this.maxSize != null && this.maxSize > -1L) {
                int intMaxSize = this.maxSize >= Integer.MAX_VALUE ? Integer.MAX_VALUE : this.maxSize.intValue();
                this.multi = new ServletMultipartRequest(servletRequest, saveDir, intMaxSize);
            } else {
                this.multi = new ServletMultipartRequest(servletRequest, saveDir);
            }
        }
    }

    public Enumeration getFileParameterNames() {
        return this.multi.getFileParameterNames();
    }

    public String[] getContentType(String fieldName) {
        return new String[]{this.multi.getContentType(fieldName)};
    }

    public UploadedFile[] getFile(String fieldName) {
        return new UploadedFile[]{StrutsUploadedFile.Builder.create((File)this.multi.getFile(fieldName)).withContentType(this.multi.getContentType(fieldName)).withOriginalName(this.multi.getFileSystemName(fieldName)).withInputName(fieldName).build()};
    }

    public String[] getFileNames(String fieldName) {
        return new String[]{this.multi.getFile(fieldName).getName()};
    }

    public String[] getFilesystemName(String fieldName) {
        return new String[]{this.multi.getFileSystemName(fieldName)};
    }

    public String getParameter(String name) {
        return this.multi.getURLParameter(name);
    }

    public Enumeration<String> getParameterNames() {
        return this.multi.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        Enumeration enumeration = this.multi.getURLParameters(name);
        if (!enumeration.hasMoreElements()) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            values.add((String)enumeration.nextElement());
        }
        return values.toArray(new String[values.size()]);
    }

    private void setEncoding() {
        String encoding = null;
        try {
            encoding = this.defaultEncoding;
            if (encoding != null) {
                MultipartRequest.setEncoding((String)encoding);
            } else {
                MultipartRequest.setEncoding((String)"UTF-8");
            }
        }
        catch (IllegalArgumentException e) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Could not get encoding property 'struts.i18n.encoding' for file upload.  Using system default");
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Encoding " + encoding + " is not a valid encoding.  Please check your struts.properties file.");
        }
    }

    public void cleanUp() {
        Enumeration fileParameterNames = this.multi.getFileParameterNames();
        while (fileParameterNames != null && fileParameterNames.hasMoreElements()) {
            UploadedFile[] files;
            String inputValue = (String)fileParameterNames.nextElement();
            for (UploadedFile currentFile : files = this.getFile(inputValue)) {
                LOG.debug("Removing file {} {}", (Object)inputValue, (Object)currentFile);
                if (currentFile == null || !currentFile.isFile() || currentFile.delete()) continue;
                LOG.warn("Resource Leaking: Could not remove uploaded file [{}]", (Object)currentFile.getAbsolutePath());
            }
        }
    }
}

