/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metrics2;

import java.util.HashMap;
import java.util.Map;
import org.apache.storm.metrics2.StormMetricRegistry;

public class TaskMetricDimensions {
    private int taskId;
    private String componentId;
    private String streamId;
    private Map<String, String> dimensions = new HashMap<String, String>();

    public TaskMetricDimensions(int taskId, String componentId, String streamId, StormMetricRegistry metricRegistry) {
        this.taskId = taskId;
        this.dimensions.put("taskid", Integer.toString(this.taskId));
        this.componentId = componentId;
        if (this.componentId == null) {
            this.componentId = "";
        } else {
            this.dimensions.put("componentId", this.componentId);
        }
        this.streamId = streamId;
        if (this.streamId == null) {
            this.streamId = "";
        } else {
            this.dimensions.put("streamId", this.streamId);
        }
        this.dimensions.put("hostname", metricRegistry.getHostName());
        this.dimensions.put("topologyId", metricRegistry.getTopologyId());
        this.dimensions.put("port", metricRegistry.getPort().toString());
    }

    public Map<String, String> getDimensions() {
        return this.dimensions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskMetricDimensions otherD = (TaskMetricDimensions)o;
        return this.taskId == otherD.taskId && this.componentId.equals(otherD.componentId) && this.streamId.equals(otherD.streamId);
    }

    public int hashCode() {
        return this.taskId + this.componentId.hashCode() + this.streamId.hashCode();
    }
}

