/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.assignments;

import java.util.Map;
import org.apache.storm.assignments.ILocalAssignmentsBackend;
import org.apache.storm.assignments.InMemoryAssignmentBackend;
import org.apache.storm.shade.com.google.common.base.Preconditions;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.ReflectionUtils;

public class LocalAssignmentsBackendFactory {
    public static ILocalAssignmentsBackend getBackend(Map<String, Object> conf) {
        if (conf.get("nimbus.local.assignments.backend.class") != null) {
            Object targetObj = ReflectionUtils.newInstance((String)conf.get("nimbus.local.assignments.backend.class"));
            Preconditions.checkState((boolean)(targetObj instanceof ILocalAssignmentsBackend), (String)"{} must implements ILocalAssignmentsBackend", (Object)"nimbus.local.assignments.backend.class");
            ((ILocalAssignmentsBackend)targetObj).prepare(conf);
            return (ILocalAssignmentsBackend)targetObj;
        }
        return LocalAssignmentsBackendFactory.getDefault();
    }

    public static ILocalAssignmentsBackend getDefault() {
        InMemoryAssignmentBackend backend = new InMemoryAssignmentBackend();
        backend.prepare(ConfigUtils.readStormConfig());
        return backend;
    }
}

