/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql.runtime.utils;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.generic.GenericData;
import org.apache.avro.util.Utf8;
import org.apache.commons.lang.StringUtils;
import org.apache.storm.spout.Scheme;
import org.apache.storm.sql.runtime.IOutputSerializer;
import org.apache.storm.sql.runtime.serde.avro.AvroScheme;
import org.apache.storm.sql.runtime.serde.avro.AvroSerializer;
import org.apache.storm.sql.runtime.serde.csv.CsvScheme;
import org.apache.storm.sql.runtime.serde.csv.CsvSerializer;
import org.apache.storm.sql.runtime.serde.json.JsonScheme;
import org.apache.storm.sql.runtime.serde.json.JsonSerializer;
import org.apache.storm.sql.runtime.serde.tsv.TsvScheme;
import org.apache.storm.sql.runtime.serde.tsv.TsvSerializer;
import org.apache.storm.utils.Utils;

public final class SerdeUtils {
    public static Scheme getScheme(String inputFormatClass, Properties properties, List<String> fieldNames) {
        Object scheme;
        if (StringUtils.isNotEmpty((String)inputFormatClass)) {
            if (JsonScheme.class.getName().equals(inputFormatClass)) {
                scheme = new JsonScheme(fieldNames);
            } else if (TsvScheme.class.getName().equals(inputFormatClass)) {
                String delimiter = properties.getProperty("input.tsv.delimiter", "\t");
                scheme = new TsvScheme(fieldNames, delimiter.charAt(0));
            } else if (CsvScheme.class.getName().equals(inputFormatClass)) {
                scheme = new CsvScheme(fieldNames);
            } else if (AvroScheme.class.getName().equals(inputFormatClass)) {
                String schemaString = properties.getProperty("input.avro.schema");
                Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)schemaString), (Object)"input.avro.schema can not be empty");
                scheme = new AvroScheme(schemaString, fieldNames);
            } else {
                scheme = (Scheme)Utils.newInstance((String)inputFormatClass);
            }
        } else {
            scheme = new JsonScheme(fieldNames);
        }
        return scheme;
    }

    public static IOutputSerializer getSerializer(String outputFormatClass, Properties properties, List<String> fieldNames) {
        IOutputSerializer serializer;
        if (StringUtils.isNotEmpty((String)outputFormatClass)) {
            if (JsonSerializer.class.getName().equals(outputFormatClass)) {
                serializer = new JsonSerializer(fieldNames);
            } else if (TsvSerializer.class.getName().equals(outputFormatClass)) {
                String delimiter = properties.getProperty("output.tsv.delimiter", "\t");
                serializer = new TsvSerializer(fieldNames, delimiter.charAt(0));
            } else if (CsvSerializer.class.getName().equals(outputFormatClass)) {
                serializer = new CsvSerializer(fieldNames);
            } else if (AvroSerializer.class.getName().equals(outputFormatClass)) {
                String schemaString = properties.getProperty("output.avro.schema");
                Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)schemaString), (Object)"output.avro.schema can not be empty");
                serializer = new AvroSerializer(schemaString, fieldNames);
            } else {
                serializer = (IOutputSerializer)Utils.newInstance((String)outputFormatClass);
            }
        } else {
            serializer = new JsonSerializer(fieldNames);
        }
        return serializer;
    }

    public static Object convertAvroUtf8(Object value) {
        Object ret = value instanceof Utf8 ? value.toString() : (value instanceof Map ? SerdeUtils.convertAvroUtf8Map((Map)value) : (value instanceof GenericData.Array ? SerdeUtils.convertAvroUtf8Array((GenericData.Array)value) : value));
        return ret;
    }

    public static Object convertAvroUtf8Map(Map<Object, Object> value) {
        HashMap<Object, Object> map = new HashMap<Object, Object>(value.size());
        for (Map.Entry<Object, Object> entry : value.entrySet()) {
            Object k = SerdeUtils.convertAvroUtf8(entry.getKey());
            Object v = SerdeUtils.convertAvroUtf8(entry.getValue());
            map.put(k, v);
        }
        return map;
    }

    public static Object convertAvroUtf8Array(GenericData.Array value) {
        ArrayList<Object> ls = new ArrayList<Object>(value.size());
        for (Object o : value) {
            ls.add(SerdeUtils.convertAvroUtf8(o));
        }
        return ls;
    }
}

