/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.zookeeper.ClientCnxn;
import org.apache.zookeeper.ClientCnxnSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCnxnSocketNIO
extends ClientCnxnSocket {
    private static final Logger LOG = LoggerFactory.getLogger(ClientCnxnSocketNIO.class);
    private final Selector selector = Selector.open();
    private SelectionKey sockKey;

    ClientCnxnSocketNIO() throws IOException {
    }

    @Override
    boolean isConnected() {
        return this.sockKey != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doIO(List<ClientCnxn.Packet> pendingQueue, LinkedList<ClientCnxn.Packet> outgoingQueue, ClientCnxn cnxn) throws InterruptedException, IOException {
        SocketChannel sock = (SocketChannel)this.sockKey.channel();
        if (sock == null) {
            throw new IOException("Socket is null!");
        }
        if (this.sockKey.isReadable()) {
            int rc = sock.read(this.incomingBuffer);
            if (rc < 0) {
                throw new ClientCnxn.EndOfStreamException("Unable to read additional data from server sessionid 0x" + Long.toHexString(this.sessionId) + ", likely server has closed socket");
            }
            if (!this.incomingBuffer.hasRemaining()) {
                this.incomingBuffer.flip();
                if (this.incomingBuffer == this.lenBuffer) {
                    ++this.recvCount;
                    this.readLength();
                } else if (!this.initialized) {
                    this.readConnectResult();
                    this.enableRead();
                    if (this.findSendablePacket(outgoingQueue, cnxn.sendThread.clientTunneledAuthenticationInProgress()) != null) {
                        this.enableWrite();
                    }
                    this.lenBuffer.clear();
                    this.incomingBuffer = this.lenBuffer;
                    this.updateLastHeard();
                    this.initialized = true;
                } else {
                    this.sendThread.readResponse(this.incomingBuffer);
                    this.lenBuffer.clear();
                    this.incomingBuffer = this.lenBuffer;
                    this.updateLastHeard();
                }
            }
        }
        if (this.sockKey.isWritable()) {
            LinkedList<ClientCnxn.Packet> linkedList = outgoingQueue;
            synchronized (linkedList) {
                ClientCnxn.Packet p = this.findSendablePacket(outgoingQueue, cnxn.sendThread.clientTunneledAuthenticationInProgress());
                if (p != null) {
                    this.updateLastSend();
                    if (p.bb == null) {
                        if (p.requestHeader != null && p.requestHeader.getType() != 11 && p.requestHeader.getType() != 100) {
                            p.requestHeader.setXid(cnxn.getXid());
                        }
                        p.createBB();
                    }
                    sock.write(p.bb);
                    if (!p.bb.hasRemaining()) {
                        ++this.sentCount;
                        outgoingQueue.removeFirstOccurrence(p);
                        if (p.requestHeader != null && p.requestHeader.getType() != 11 && p.requestHeader.getType() != 100) {
                            List<ClientCnxn.Packet> list2 = pendingQueue;
                            synchronized (list2) {
                                pendingQueue.add(p);
                            }
                        }
                    }
                }
                if (outgoingQueue.isEmpty()) {
                    this.disableWrite();
                } else if (!this.initialized && p != null && !p.bb.hasRemaining()) {
                    this.disableWrite();
                } else {
                    this.enableWrite();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientCnxn.Packet findSendablePacket(LinkedList<ClientCnxn.Packet> outgoingQueue, boolean clientTunneledAuthenticationInProgress) {
        LinkedList<ClientCnxn.Packet> linkedList = outgoingQueue;
        synchronized (linkedList) {
            if (outgoingQueue.isEmpty()) {
                return null;
            }
            if (outgoingQueue.getFirst().bb != null || !clientTunneledAuthenticationInProgress) {
                return outgoingQueue.getFirst();
            }
            ListIterator iter2 = outgoingQueue.listIterator();
            while (iter2.hasNext()) {
                ClientCnxn.Packet p = (ClientCnxn.Packet)iter2.next();
                if (p.requestHeader == null) {
                    iter2.remove();
                    outgoingQueue.add(0, p);
                    return p;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("deferring non-priming packet: " + p + "until SASL authentication completes.");
            }
            return null;
        }
    }

    @Override
    void cleanup() {
        block15: {
            block14: {
                if (this.sockKey != null) {
                    SocketChannel sock;
                    block13: {
                        block12: {
                            block11: {
                                sock = (SocketChannel)this.sockKey.channel();
                                this.sockKey.cancel();
                                try {
                                    sock.socket().shutdownInput();
                                }
                                catch (IOException e) {
                                    if (!LOG.isDebugEnabled()) break block11;
                                    LOG.debug("Ignoring exception during shutdown input", e);
                                }
                            }
                            try {
                                sock.socket().shutdownOutput();
                            }
                            catch (IOException e) {
                                if (!LOG.isDebugEnabled()) break block12;
                                LOG.debug("Ignoring exception during shutdown output", e);
                            }
                        }
                        try {
                            sock.socket().close();
                        }
                        catch (IOException e) {
                            if (!LOG.isDebugEnabled()) break block13;
                            LOG.debug("Ignoring exception during socket close", e);
                        }
                    }
                    try {
                        sock.close();
                    }
                    catch (IOException e) {
                        if (!LOG.isDebugEnabled()) break block14;
                        LOG.debug("Ignoring exception during channel close", e);
                    }
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                if (!LOG.isDebugEnabled()) break block15;
                LOG.debug("SendThread interrupted during sleep, ignoring");
            }
        }
        this.sockKey = null;
    }

    @Override
    void close() {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Doing client selector close");
            }
            this.selector.close();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Closed client selector");
            }
        }
        catch (IOException e) {
            LOG.warn("Ignoring exception during selector close", e);
        }
    }

    SocketChannel createSock() throws IOException {
        SocketChannel sock = SocketChannel.open();
        sock.configureBlocking(false);
        sock.socket().setSoLinger(false, -1);
        sock.socket().setTcpNoDelay(true);
        return sock;
    }

    void registerAndConnect(SocketChannel sock, InetSocketAddress addr) throws IOException {
        this.sockKey = sock.register(this.selector, 8);
        boolean immediateConnect = sock.connect(addr);
        if (immediateConnect) {
            this.sendThread.primeConnection();
        }
    }

    @Override
    void connect(InetSocketAddress addr) throws IOException {
        SocketChannel sock = this.createSock();
        try {
            this.registerAndConnect(sock, addr);
        }
        catch (IOException e) {
            LOG.error("Unable to open socket to " + addr);
            sock.close();
            throw e;
        }
        this.initialized = false;
        this.lenBuffer.clear();
        this.incomingBuffer = this.lenBuffer;
    }

    @Override
    SocketAddress getRemoteSocketAddress() {
        try {
            return ((SocketChannel)this.sockKey.channel()).socket().getRemoteSocketAddress();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    @Override
    SocketAddress getLocalSocketAddress() {
        try {
            return ((SocketChannel)this.sockKey.channel()).socket().getLocalSocketAddress();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    @Override
    synchronized void wakeupCnxn() {
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doTransport(int waitTimeOut, List<ClientCnxn.Packet> pendingQueue, LinkedList<ClientCnxn.Packet> outgoingQueue, ClientCnxn cnxn) throws IOException, InterruptedException {
        Set<SelectionKey> selected;
        this.selector.select(waitTimeOut);
        LinkedList<ClientCnxn.Packet> linkedList = this;
        synchronized (linkedList) {
            selected = this.selector.selectedKeys();
        }
        this.updateNow();
        for (SelectionKey k : selected) {
            SocketChannel sc = (SocketChannel)k.channel();
            if ((k.readyOps() & 8) != 0) {
                if (!sc.finishConnect()) continue;
                this.updateLastSendAndHeard();
                this.sendThread.primeConnection();
                continue;
            }
            if ((k.readyOps() & 5) == 0) continue;
            this.doIO(pendingQueue, outgoingQueue, cnxn);
        }
        if (this.sendThread.getZkState().isConnected()) {
            linkedList = outgoingQueue;
            synchronized (linkedList) {
                if (this.findSendablePacket(outgoingQueue, cnxn.sendThread.clientTunneledAuthenticationInProgress()) != null) {
                    this.enableWrite();
                }
            }
        }
        selected.clear();
    }

    @Override
    void testableCloseSocket() throws IOException {
        LOG.info("testableCloseSocket() called");
        ((SocketChannel)this.sockKey.channel()).socket().close();
    }

    @Override
    synchronized void enableWrite() {
        int i = this.sockKey.interestOps();
        if ((i & 4) == 0) {
            this.sockKey.interestOps(i | 4);
        }
    }

    @Override
    public synchronized void disableWrite() {
        int i = this.sockKey.interestOps();
        if ((i & 4) != 0) {
            this.sockKey.interestOps(i & 0xFFFFFFFB);
        }
    }

    private synchronized void enableRead() {
        int i = this.sockKey.interestOps();
        if ((i & 1) == 0) {
            this.sockKey.interestOps(i | 1);
        }
    }

    @Override
    synchronized void enableReadWriteOnly() {
        this.sockKey.interestOps(5);
    }

    Selector getSelector() {
        return this.selector;
    }

    @Override
    void sendPacket(ClientCnxn.Packet p) throws IOException {
        SocketChannel sock = (SocketChannel)this.sockKey.channel();
        if (sock == null) {
            throw new IOException("Socket is null!");
        }
        p.createBB();
        ByteBuffer pbb = p.bb;
        sock.write(pbb);
    }
}

