/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart.run;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;

public class PortHelper {
    private static final Set<Integer> USED_PORTS = new HashSet<Integer>();

    public static synchronized int getNextAvailablePort() throws MojoExecutionException {
        int unusedPort = 0;
        do {
            try {
                ServerSocket socket = new ServerSocket(0);
                unusedPort = socket.getLocalPort();
                socket.close();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error getting an available port from system", (Exception)e);
            }
        } while (USED_PORTS.contains(unusedPort));
        USED_PORTS.add(unusedPort);
        return unusedPort;
    }
}

