/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.builder;

import java.util.Map;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.builder.ContentBuilder;
import org.apache.sling.testing.mock.sling.junit.SlingContext;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ContentBuilderTest {
    @Rule
    public SlingContext context = new SlingContext(ResourceResolverType.RESOURCERESOLVER_MOCK);

    @Test
    public void testResourceWithInvalidParent() {
        ContentBuilder create = this.context.create();
        Assert.assertThrows(IllegalArgumentException.class, () -> create.resource("/"));
    }

    @Test
    public void testResourceWithPersistenceException() throws PersistenceException {
        ResourceResolver mockRR = (ResourceResolver)Mockito.mock(ResourceResolver.class);
        Mockito.when((Object)mockRR.create((Resource)ArgumentMatchers.nullable(Resource.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap())).thenThrow(PersistenceException.class);
        ContentBuilder create = new ContentBuilder(mockRR);
        Assert.assertThrows(RuntimeException.class, () -> create.resource("/content"));
    }

    @Test
    public void testResource() {
        Resource resource = this.context.create().resource("/content/test1/resource1");
        Assert.assertNotNull((Object)resource);
        Assert.assertEquals((Object)"resource1", (Object)resource.getName());
        Assert.assertTrue((boolean)ResourceUtil.getValueMap((Resource)resource).isEmpty());
    }

    @Test
    public void testResourceWithProperties_Map() {
        Resource resource = this.context.create().resource("/content/test1/resource2", Map.of("jcr:title", "Test Title", "stringProp", "value1"));
        Assert.assertNotNull((Object)resource);
        Assert.assertEquals((Object)"resource2", (Object)resource.getName());
        ValueMap props = ResourceUtil.getValueMap((Resource)resource);
        Assert.assertEquals((Object)"Test Title", (Object)props.get("jcr:title", String.class));
        Assert.assertEquals((Object)"value1", (Object)props.get("stringProp", String.class));
    }

    @Test
    public void testResourceWithProperties_ObjectArray() {
        Resource resource = this.context.create().resource("/content/test1/resource2", new Object[]{"jcr:title", "Test Title", "stringProp", "value1"});
        Assert.assertNotNull((Object)resource);
        Assert.assertEquals((Object)"resource2", (Object)resource.getName());
        ValueMap props = ResourceUtil.getValueMap((Resource)resource);
        Assert.assertEquals((Object)"Test Title", (Object)props.get("jcr:title", String.class));
        Assert.assertEquals((Object)"value1", (Object)props.get("stringProp", String.class));
    }

    @Test
    public void testChildResource() {
        Resource resource = this.context.create().resource("/content/test1/resource1");
        Resource child1 = this.context.create().resource(resource, "child1");
        Assert.assertNotNull((Object)child1);
        Assert.assertEquals((Object)"child1", (Object)child1.getName());
        Assert.assertTrue((boolean)ResourceUtil.getValueMap((Resource)child1).isEmpty());
        Resource child2 = this.context.create().resource(resource, "/child2", new Object[]{"prop1", "value1"});
        Assert.assertNotNull((Object)child2);
        Assert.assertEquals((Object)"child2", (Object)child2.getName());
        ValueMap props = ResourceUtil.getValueMap((Resource)child2);
        Assert.assertEquals((Object)"value1", (Object)props.get("prop1", String.class));
    }

    @Test
    public void testEnsureResourceExists() {
        ContentBuilder create = this.context.create();
        Assert.assertNotNull((Object)create.ensureResourceExists(null));
        Assert.assertNotNull((Object)create.ensureResourceExists(""));
        Assert.assertNotNull((Object)create.ensureResourceExists("/"));
        Assert.assertThrows(IllegalArgumentException.class, () -> create.ensureResourceExists("invalid"));
    }

    @Test
    public void testEnsureResourceExistsWithPersistenceException() throws PersistenceException {
        ResourceResolver mockRR = (ResourceResolver)Mockito.mock(ResourceResolver.class);
        Mockito.when((Object)mockRR.create((Resource)ArgumentMatchers.nullable(Resource.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap())).thenThrow(PersistenceException.class);
        ContentBuilder create = new ContentBuilder(mockRR);
        Assert.assertThrows(RuntimeException.class, () -> create.ensureResourceExists("/content/node1"));
    }
}

