/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data;

import java.io.InputStream;
import org.apache.jackrabbit.core.data.AbstractDataRecord;
import org.apache.jackrabbit.core.data.CachingDataStore;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingDataRecord
extends AbstractDataRecord {
    private static final Logger LOG = LoggerFactory.getLogger(CachingDataRecord.class);
    private final CachingDataStore store;

    public CachingDataRecord(CachingDataStore store, DataIdentifier identifier) {
        super(store, identifier);
        this.store = store;
    }

    @Override
    public long getLastModified() {
        try {
            return this.store.getLastModified(this.getIdentifier());
        }
        catch (DataStoreException dse) {
            LOG.info("exception in getLastModified for identifier [" + String.valueOf(this.getIdentifier()) + "]. returning 0.", (Throwable)((Object)dse));
            return 0L;
        }
    }

    @Override
    public long getLength() throws DataStoreException {
        return this.store.getLength(this.getIdentifier());
    }

    @Override
    public InputStream getStream() throws DataStoreException {
        return this.store.getStream(this.getIdentifier());
    }
}

