/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.junit.rules.instance.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sling.testing.clients.instance.InstanceConfiguration;
import org.apache.sling.testing.clients.instance.InstanceSetup;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationPool {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationPool.class);
    private static final List<InstanceConfiguration> configurations = ConfigurationPool.initialConfigurations();
    private static final Set<Integer> takenConfigurations = new HashSet<Integer>();
    private static final Map<Description, Set<Integer>> takenConfigurationsByDescription = new HashMap<Description, Set<Integer>>();

    private static List<InstanceConfiguration> initialConfigurations() {
        LOG.info("Reading initial configurations from the system properties");
        List configurationsFromPlugin = InstanceSetup.get().getConfigurations();
        if (!configurationsFromPlugin.isEmpty()) {
            LOG.info("Found {} instance configuration(s) from the system properties", (Object)configurationsFromPlugin.size());
            return configurationsFromPlugin;
        }
        LOG.info("No instance configurations found from the system properties");
        ArrayList<InstanceConfiguration> configurations = new ArrayList<InstanceConfiguration>();
        return configurations;
    }

    public List<InstanceConfiguration> getConfigurations() {
        return new ArrayList<InstanceConfiguration>(configurations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTaken(int configurationIndex) {
        Class<ConfigurationPool> clazz = ConfigurationPool.class;
        synchronized (ConfigurationPool.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return takenConfigurations.contains(configurationIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstanceConfiguration takeConfiguration(Description description, int configurationIndex) {
        Class<ConfigurationPool> clazz = ConfigurationPool.class;
        synchronized (ConfigurationPool.class) {
            if (this.isTaken(configurationIndex)) {
                throw new IllegalStateException("Requested configuration is already taken");
            }
            Set<Integer> indices = takenConfigurationsByDescription.get(description);
            if (indices == null) {
                indices = new HashSet<Integer>();
            }
            indices.add(configurationIndex);
            LOG.debug("Test {} took configuration with index {}", (Object)description, (Object)configurationIndex);
            takenConfigurationsByDescription.put(description, indices);
            takenConfigurations.add(configurationIndex);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return configurations.get(configurationIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnConfiguration(Description description, int configurationIndex) {
        Class<ConfigurationPool> clazz = ConfigurationPool.class;
        synchronized (ConfigurationPool.class) {
            if (!this.isTaken(configurationIndex)) {
                throw new IllegalStateException("Returned configuration is not taken by anyone");
            }
            Set<Integer> indices = takenConfigurationsByDescription.get(description);
            if (indices == null) {
                throw new IllegalStateException("The test didn't take any configuration");
            }
            if (!indices.contains(configurationIndex)) {
                throw new IllegalStateException("The returned configuration was not taken by the test");
            }
            indices.remove(configurationIndex);
            LOG.debug("Test {} returned configuration with index {}", (Object)description, (Object)configurationIndex);
            if (indices.isEmpty()) {
                takenConfigurationsByDescription.remove(description);
            }
            takenConfigurations.remove(configurationIndex);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer addAndTakeConfiguration(Description description, InstanceConfiguration configuration) {
        Class<ConfigurationPool> clazz = ConfigurationPool.class;
        synchronized (ConfigurationPool.class) {
            configurations.add(configuration);
            Integer index = configurations.size() - 1;
            this.takeConfiguration(description, index);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return index;
        }
    }
}

