/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.compiler.expression.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.sling.scripting.sightly.compiler.SightlyCompilerException;
import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.compiler.expression.NodeVisitor;

public final class RuntimeCall
implements ExpressionNode {
    public static final String FORMAT = "format";
    public static final String I18N = "i18n";
    public static final String JOIN = "join";
    public static final String URI_MANIPULATION = "uriManipulation";
    public static final String XSS = "xss";
    public static final String INCLUDE = "include";
    public static final String RESOURCE = "includeResource";
    public static final String USE = "use";
    private static final Set<String> RUNTIME_FUNCTIONS = new HashSet<String>();
    private final String functionName;
    private final List<ExpressionNode> arguments;

    public RuntimeCall(String functionName, ExpressionNode ... arguments) {
        this(functionName, Arrays.asList(arguments));
    }

    public RuntimeCall(String functionName, List<ExpressionNode> arguments) {
        if (!RUNTIME_FUNCTIONS.contains(functionName)) {
            throw new SightlyCompilerException(String.format("Function %s is not a recognised runtime function - %s.", functionName, RUNTIME_FUNCTIONS));
        }
        this.functionName = functionName;
        this.arguments = new ArrayList<ExpressionNode>(arguments);
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public List<ExpressionNode> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.evaluate(this);
    }

    static {
        RUNTIME_FUNCTIONS.add(USE);
        RUNTIME_FUNCTIONS.add(RESOURCE);
        RUNTIME_FUNCTIONS.add(INCLUDE);
        RUNTIME_FUNCTIONS.add(I18N);
        RUNTIME_FUNCTIONS.add(XSS);
        RUNTIME_FUNCTIONS.add(URI_MANIPULATION);
        RUNTIME_FUNCTIONS.add(JOIN);
        RUNTIME_FUNCTIONS.add(FORMAT);
    }
}

