/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.core.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.wrappers.ResourceResolverWrapper;
import org.apache.sling.scripting.api.resource.ScriptingResourceResolverProvider;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptingResourceResolver
extends ResourceResolverWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptingResourceResolver.class);
    private ResourceResolver delegate;
    private boolean shouldLogClosing = false;

    public ScriptingResourceResolver(boolean shouldLogClosing, ResourceResolver delegate) {
        super(delegate);
        this.shouldLogClosing = shouldLogClosing;
        this.delegate = delegate;
    }

    @NotNull
    public ResourceResolver clone(Map<String, Object> authenticationInfo) throws LoginException {
        return new ScriptingResourceResolver(this.shouldLogClosing, this.delegate.clone(null));
    }

    public void close() {
        LOGGER.warn("Attempted to call close on the scripting per-request resource resolver. This is handled automatically by the {}.", (Object)ScriptingResourceResolverProvider.class.getName());
        if (this.shouldLogClosing) {
            StringWriter writer = new StringWriter();
            Throwable t = new Throwable();
            t.printStackTrace(new PrintWriter(writer));
            LOGGER.warn("The following code attempted to close the per-request resource resolver: {}", (Object)writer);
        }
    }

    void _close() {
        this.delegate.close();
    }
}

