/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.bundle.tracker.internal;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.scripting.ScriptEvaluationException;
import org.apache.sling.scripting.bundle.tracker.internal.BundledScriptFinder;
import org.apache.sling.scripting.bundle.tracker.internal.Executable;
import org.apache.sling.scripting.bundle.tracker.internal.RequestWrapper;
import org.apache.sling.scripting.bundle.tracker.internal.ScriptContextProvider;
import org.apache.sling.scripting.bundle.tracker.internal.TypeProvider;
import org.apache.sling.scripting.core.ScriptHelper;

class BundledScriptServlet
extends GenericServlet {
    private final BundledScriptFinder m_bundledScriptFinder;
    private final ScriptContextProvider m_scriptContextProvider;
    private final LinkedHashSet<TypeProvider> m_wiredTypeProviders;
    private final boolean m_precompiledScripts;
    private Map<String, Executable> scriptsMap = new HashMap<String, Executable>();
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    BundledScriptServlet(BundledScriptFinder bundledScriptFinder, ScriptContextProvider scriptContextProvider, LinkedHashSet<TypeProvider> wiredTypeProviders, boolean precompiledScripts) {
        this.m_bundledScriptFinder = bundledScriptFinder;
        this.m_scriptContextProvider = scriptContextProvider;
        this.m_wiredTypeProviders = wiredTypeProviders;
        this.m_precompiledScripts = precompiledScripts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        Executable executable;
        SlingHttpServletResponse response;
        SlingHttpServletRequest request;
        block16: {
            String contentType;
            if (!(req instanceof SlingHttpServletRequest) || !(res instanceof SlingHttpServletResponse)) throw new ServletException("Not a Sling HTTP request/response");
            request = (SlingHttpServletRequest)req;
            response = (SlingHttpServletResponse)res;
            if (request.getAttribute("javax.servlet.include.servlet_path") == null && (contentType = request.getResponseContentType()) != null) {
                response.setContentType(contentType);
                if (contentType.startsWith("text/")) {
                    response.setCharacterEncoding("UTF-8");
                }
            }
            String scriptsMapKey = this.getScriptsMapKey(request);
            this.lock.readLock().lock();
            try {
                executable = this.scriptsMap.get(scriptsMapKey);
                if (executable != null) break block16;
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    executable = this.scriptsMap.get(scriptsMapKey);
                    if (executable == null && (executable = this.m_bundledScriptFinder.getScript(request, this.m_wiredTypeProviders, this.m_precompiledScripts)) != null) {
                        this.scriptsMap.put(scriptsMapKey, executable);
                    }
                    this.lock.readLock().lock();
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        if (executable == null) throw new ServletException("Unable to locate a " + (this.m_precompiledScripts ? "class" : "script") + " for rendering.");
        HashSet<String> wiredResourceTypes = new HashSet<String>();
        for (TypeProvider typeProvider : this.m_wiredTypeProviders) {
            wiredResourceTypes.add(typeProvider.getType());
        }
        RequestWrapper requestWrapper = new RequestWrapper(request, wiredResourceTypes);
        ScriptContext scriptContext = this.m_scriptContextProvider.prepareScriptContext((SlingHttpServletRequest)requestWrapper, response, executable);
        try {
            executable.eval(scriptContext);
            return;
        }
        catch (ScriptException se) {
            Throwable throwable = se.getCause() == null ? se : se.getCause();
            throw new ScriptEvaluationException(executable.getName(), se.getMessage(), throwable);
        }
        finally {
            Object scriptHelper;
            Bindings engineBindings = scriptContext.getBindings(100);
            if (engineBindings != null && engineBindings.containsKey("sling") && (scriptHelper = engineBindings.get("sling")) instanceof ScriptHelper) {
                ((ScriptHelper)scriptHelper).cleanup();
            }
            executable.releaseDependencies();
        }
    }

    private String getScriptsMapKey(SlingHttpServletRequest request) {
        RequestPathInfo requestPathInfo = request.getRequestPathInfo();
        String selectorString = requestPathInfo.getSelectorString();
        String requestExtension = requestPathInfo.getExtension();
        return request.getMethod() + ":" + request.getResource().getResourceType() + (StringUtils.isNotEmpty((CharSequence)selectorString) ? ":" + selectorString : "") + (StringUtils.isNotEmpty((CharSequence)requestExtension) ? ":" + requestExtension : "");
    }
}

