/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.repoinit.impl;

import java.io.Reader;
import java.io.StringReader;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.commons.metrics.MetricsService;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.api.SlingRepositoryInitializer;
import org.apache.sling.jcr.repoinit.JcrRepoInitOpsProcessor;
import org.apache.sling.jcr.repoinit.impl.RepoInitException;
import org.apache.sling.jcr.repoinit.impl.RepoinitTextProvider;
import org.apache.sling.jcr.repoinit.impl.RetryableOperation;
import org.apache.sling.repoinit.parser.RepoInitParser;
import org.apache.sling.repoinit.parser.operations.Operation;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Designate(ocd=Config.class, factory=true)
@Component(service={SlingRepositoryInitializer.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, configurationPid={"org.apache.sling.jcr.repoinit.RepositoryInitializer"}, property={"service.vendor=The Apache Software Foundation", "service.ranking:Integer=100"})
public class RepositoryInitializerFactory
implements SlingRepositoryInitializer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String METRIC_REPOINIT_FAILED = RepositoryInitializerFactory.class.getName() + ".failed";
    @Reference
    private RepoInitParser parser;
    @Reference
    private JcrRepoInitOpsProcessor processor;
    @Reference
    MetricsService metrics;
    private Config config;
    private AtomicBoolean aRepoInitStatementFailed = new AtomicBoolean(false);
    private String componentId;

    @Activate
    public void activate(Config config, Map<String, Object> properties) {
        this.config = config;
        this.componentId = properties.getOrDefault("component.id", "").toString();
        this.log.debug("Activated: {}", (Object)this);
        this.metrics.gauge(METRIC_REPOINIT_FAILED, this::failureStateAsMetric);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ", references=" + Arrays.toString(this.config.references()) + ", scripts=" + (this.config.scripts() != null ? this.config.scripts().length : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRepository(SlingRepository repo) throws Exception {
        if (this.config.references() != null && this.config.references().length > 0 || this.config.scripts() != null && this.config.scripts().length > 0) {
            Session s = repo.loginAdministrative(null);
            try {
                Instant start = Instant.now();
                if (this.config.references() != null) {
                    RepoinitTextProvider p = new RepoinitTextProvider();
                    for (String reference : this.config.references()) {
                        List ops;
                        if (reference == null || reference.trim().length() == 0) continue;
                        String repoinitText = p.getRepoinitText("raw:" + reference);
                        try (StringReader sr = new StringReader(repoinitText);){
                            ops = this.parser.parse((Reader)sr);
                        }
                        String sourceReference = String.format("Configuration PID %s, reference URL %s", this.componentId, reference);
                        String msg = String.format("Executing %s repoinit operations from \"%s\"", ops.size(), sourceReference);
                        this.log.info(msg);
                        this.applyOperations(s, ops, msg, sourceReference);
                    }
                }
                if (this.config.scripts() != null) {
                    int scriptIndex = 0;
                    for (String script : this.config.scripts()) {
                        List ops;
                        if (script == null || script.trim().length() == 0) continue;
                        try (StringReader sr = new StringReader(script);){
                            ops = this.parser.parse((Reader)sr);
                        }
                        String sourceReference = String.format("Configuration PID %s, script[%d]", this.componentId, scriptIndex);
                        String msg = String.format("Executing %s repoinit operations from \"%s\"", ops.size(), sourceReference);
                        this.log.info(msg);
                        this.applyOperations(s, ops, msg, sourceReference);
                        ++scriptIndex;
                    }
                }
                Duration duration = Duration.between(start, Instant.now());
                this.log.info("Total time for successful repoinit execution: {} miliseconds", (Object)duration.toMillis());
            }
            finally {
                s.logout();
            }
        }
    }

    protected void applyOperations(Session session, List<Operation> ops, String logMessage, String reference) throws RepositoryException {
        RetryableOperation retry = new RetryableOperation.Builder().withBackoffBaseMsec(1000).withMaxRetries(3).build();
        RetryableOperation.RetryableOperationResult result = this.applyOperationInternal(session, ops, logMessage, reference, retry);
        if (!result.isSuccessful()) {
            String msg = String.format("Applying repoinit operation failed despite retry; set loglevel to DEBUG to see all exceptions. Last exception message from \"%s\" was: %s", result.getReference(), result.getFailureTrace().getMessage());
            this.aRepoInitStatementFailed.set(true);
            throw new RepositoryException(msg, (Throwable)result.getFailureTrace());
        }
    }

    protected RetryableOperation.RetryableOperationResult applyOperationInternal(Session session, List<Operation> ops, String logMessage, String reference, RetryableOperation retry) {
        return retry.apply(() -> {
            try {
                this.processor.apply(session, ops);
                if (session.hasPendingChanges()) {
                    session.save();
                }
                return new RetryableOperation.RetryableOperationResult(true, false, reference, null);
            }
            catch (InvalidItemStateException | RepoInitException ex) {
                this.log.debug("(temporarily) failed to apply repoinit operations", ex);
                try {
                    session.refresh(false);
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
                return new RetryableOperation.RetryableOperationResult(false, true, reference, (Exception)ex);
            }
            catch (RepositoryException ex) {
                try {
                    session.refresh(false);
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
                return new RetryableOperation.RetryableOperationResult(false, false, reference, (Exception)((Object)ex));
            }
        }, logMessage);
    }

    protected int failureStateAsMetric() {
        return this.aRepoInitStatementFailed.get() ? 1 : 0;
    }

    @ObjectClassDefinition(name="Apache Sling Repository Initializer Factory", description="Initializes the JCR content repository using repoinit statements.")
    public static @interface Config {
        @AttributeDefinition(name="References", description="References to the source text that provides repoinit statements. format is a raw URL.")
        public String[] references() default {};

        @AttributeDefinition(name="Scripts", description="Contents of a repo init script.")
        public String[] scripts() default {};
    }
}

