/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.query.lucene.ForeignSegmentDocId;
import org.apache.jackrabbit.core.query.lucene.HierarchyResolver;
import org.apache.jackrabbit.core.query.lucene.MultiIndexReader;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;

public final class JackrabbitIndexReader
extends FilterIndexReader
implements HierarchyResolver,
MultiIndexReader {
    private final HierarchyResolver resolver;
    private final MultiIndexReader reader;

    public JackrabbitIndexReader(IndexReader in) {
        super(in);
        if (!(in instanceof MultiIndexReader)) {
            throw new IllegalArgumentException("IndexReader must also implement MultiIndexReader");
        }
        if (!(in instanceof HierarchyResolver)) {
            throw new IllegalArgumentException("IndexReader must also implement HierarchyResolver");
        }
        this.resolver = (HierarchyResolver)((Object)in);
        this.reader = (MultiIndexReader)((Object)in);
    }

    @Override
    public TermDocs termDocs(Term term) throws IOException {
        return this.in.termDocs(term);
    }

    @Override
    protected void doClose() throws IOException {
        this.reader.release();
    }

    @Override
    public int[] getParents(int n, int[] docNumbers) throws IOException {
        return this.resolver.getParents(n, docNumbers);
    }

    @Override
    public IndexReader[] getIndexReaders() {
        return this.reader.getIndexReaders();
    }

    @Override
    public IndexReader[] getSequentialSubReaders() {
        return null;
    }

    @Override
    public ForeignSegmentDocId createDocId(NodeId id) throws IOException {
        return this.reader.createDocId(id);
    }

    @Override
    public int getDocumentNumber(ForeignSegmentDocId docId) throws IOException {
        return this.reader.getDocumentNumber(docId);
    }

    @Override
    public void release() throws IOException {
        this.reader.release();
    }
}

