/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.api.serializer;

import org.apache.sling.installer.api.serializer.ConfigurationSerializer;
import org.apache.sling.installer.core.impl.serializer.ConfigConfigurationSerializer;
import org.apache.sling.installer.core.impl.serializer.JsonConfigurationSerializer;
import org.apache.sling.installer.core.impl.serializer.PropertiesConfigurationSerializer;
import org.jetbrains.annotations.NotNull;

public class ConfigurationSerializerFactory {
    private ConfigurationSerializerFactory() {
    }

    @NotNull
    public static ConfigurationSerializer create(@NotNull Format format) {
        ConfigurationSerializer serializer;
        switch (format.ordinal()) {
            case 1: {
                serializer = new ConfigConfigurationSerializer();
                break;
            }
            case 2: {
                serializer = new PropertiesConfigurationSerializer(false);
                break;
            }
            case 3: {
                serializer = new PropertiesConfigurationSerializer(true);
                break;
            }
            default: {
                serializer = new JsonConfigurationSerializer();
            }
        }
        return serializer;
    }

    public static enum Format {
        JSON,
        CONFIG,
        PROPERTIES,
        PROPERTIES_XML;

    }
}

