/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.sling.installer.core.impl.FileDataStore;

public class ResourceData {
    private final Dictionary<String, Object> dictionary;
    private final File dataFile;

    public static ResourceData create(InputStream stream, Dictionary<String, Object> props) throws IOException {
        if (stream == null) {
            Hashtable<String, Object> result = new Hashtable<String, Object>();
            Enumeration<String> e = props.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                ((Dictionary)result).put(key, props.get(key));
            }
            return new ResourceData(result, null);
        }
        File dataFile = FileDataStore.SHARED.createNewDataFile(stream, null, null, null);
        return new ResourceData(null, dataFile);
    }

    private ResourceData(Dictionary<String, Object> dict, File dataFile) {
        this.dictionary = dict;
        this.dataFile = dataFile;
    }

    public Dictionary<String, Object> getDictionary() {
        return this.dictionary;
    }

    public InputStream getInputStream() throws IOException {
        if (this.dataFile != null) {
            return new FileInputStream(this.dataFile);
        }
        return null;
    }

    public String getDigest(String url, String digest) throws IOException {
        if (this.dictionary != null) {
            return digest != null ? digest : FileDataStore.computeDigest(this.dictionary);
        }
        if (digest == null) {
            digest = FileDataStore.computeDigest(this.dataFile);
        }
        FileDataStore.SHARED.updateDigestCache(url, this.dataFile, digest);
        return digest;
    }

    public File getDataFile() {
        return this.dataFile;
    }
}

