/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import relocated_for_contentpackage.org.apache.commons.io.FileUtils;
import relocated_for_contentpackage.org.apache.commons.io.filefilter.NameFileFilter;
import relocated_for_contentpackage.org.apache.commons.io.filefilter.SuffixFileFilter;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.PackageId;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.PackageInfo;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.PackageType;

public class DefaultPackageInfo
implements PackageInfo {
    private static final File PROPERTIES_FILE = new File("META-INF/vault/properties.xml");
    private static final File FILTER_FILE = new File("META-INF/vault/filter.xml");
    private static final File MANIFEST_FILE = new File("META-INF/MANIFEST.MF");
    private final PackageId id;
    private final WorkspaceFilter filter;
    private final PackageType packageType;

    public DefaultPackageInfo(PackageId id, WorkspaceFilter filter, PackageType packageType) {
        this.id = id;
        this.filter = filter;
        this.packageType = packageType;
    }

    @Nullable
    public static PackageInfo read(@NotNull File file) throws IOException {
        DefaultPackageInfo info = new DefaultPackageInfo(null, null, PackageType.MIXED);
        if (!file.exists()) {
            throw new FileNotFoundException("Could not find file " + file);
        }
        if (file.isDirectory()) {
            for (File directoryFile : FileUtils.listFiles(file, new NameFileFilter("MANIFEST.MF", "properties.xml", "filter.xml"), new SuffixFileFilter("META-INF", "vault"))) {
                try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(directoryFile));){
                    info = DefaultPackageInfo.readFromInputStream(new File(file.toURI().relativize(directoryFile.toURI()).getPath()), input, info);
                    if (info.getId() == null || info.getFilter() == null) continue;
                    break;
                }
            }
            if (info.getId() == null || info.getFilter() == null) {
                return null;
            }
            return info;
        }
        if (file.getName().endsWith(".zip")) {
            try (ZipFile zip = new ZipFile(file);){
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry e = entries.nextElement();
                    InputStream input = zip.getInputStream(e);
                    try {
                        info = DefaultPackageInfo.readFromInputStream(new File(e.getName()), input, info);
                        if (info.getId() == null || info.getFilter() == null) continue;
                        break;
                    }
                    finally {
                        if (input == null) continue;
                        input.close();
                    }
                }
            }
            if (info.getId() == null || info.getFilter() == null) {
                return null;
            }
            return info;
        }
        throw new IOException("Only metadata from zip files could be extracted but the given file is not a zip:" + file);
    }

    private static DefaultPackageInfo readFromInputStream(File file, InputStream input, PackageInfo alreadyFoundInfo) throws IOException {
        PackageId id = alreadyFoundInfo.getId();
        WorkspaceFilter filter = alreadyFoundInfo.getFilter();
        DefaultWorkspaceFilter defaultFilter = new DefaultWorkspaceFilter();
        PackageType packageType = alreadyFoundInfo.getPackageType();
        if (MANIFEST_FILE.equals(file)) {
            String type;
            String roots;
            Manifest mf = new Manifest(input);
            String idStr = mf.getMainAttributes().getValue("Content-Package-Id");
            if (idStr != null) {
                id = PackageId.fromString(idStr);
            }
            if ((roots = mf.getMainAttributes().getValue("Content-Package-Roots")) != null) {
                for (String root : roots.split(",")) {
                    defaultFilter.add(new PathFilterSet(root));
                }
                filter = defaultFilter;
            }
            if ((type = mf.getMainAttributes().getValue("Content-Package-Type")) != null) {
                packageType = PackageType.valueOf(type.toUpperCase());
            }
        } else if (PROPERTIES_FILE.equals(file)) {
            Properties props = new Properties();
            props.loadFromXML(input);
            String version = props.getProperty("version");
            if (version == null) {
                version = "";
            }
            String group = props.getProperty("group");
            String name = props.getProperty("name");
            if (group != null && name != null) {
                id = new PackageId(group, name, version);
            } else {
                String path = props.getProperty("path");
                if (path == null || path.length() == 0) {
                    path = "/etc/packages/unknown";
                }
                id = new PackageId(path, version);
            }
        } else if (FILTER_FILE.equals(file)) {
            try {
                defaultFilter.load(input);
            }
            catch (ConfigurationException e1) {
                throw new IOException(e1);
            }
            filter = defaultFilter;
        }
        return new DefaultPackageInfo(id, filter, packageType);
    }

    @Override
    public PackageId getId() {
        return this.id;
    }

    @Override
    public WorkspaceFilter getFilter() {
        return this.filter;
    }

    @Override
    public PackageType getPackageType() {
        return this.packageType;
    }
}

