/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.impl.aggregator;

import relocated_for_contentpackage.javax.jcr.Node;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.javax.jcr.Session;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.ArtifactType;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.DumpContext;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.ImportInfo;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.filter.NodeTypeItemFilter;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.impl.AggregateImpl;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.impl.ArtifactSetImpl;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.impl.aggregator.GenericAggregator;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.impl.io.CNDSerializer;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.impl.io.ImportInfoImpl;

public class NodeTypeAggregator
extends GenericAggregator {
    @Override
    public boolean hasFullCoverage() {
        return true;
    }

    @Override
    public boolean matches(Node node, String path) throws RepositoryException {
        if (this.getMatchFilter().isEmpty()) {
            this.getMatchFilter().addInclude(new NodeTypeItemFilter("nt:nodeType", true));
        }
        return super.matches(node, path);
    }

    public ArtifactSetImpl createArtifacts(AggregateImpl aggregate) throws RepositoryException {
        ArtifactSetImpl artifacts = new ArtifactSetImpl();
        CNDSerializer ser = new CNDSerializer(aggregate);
        artifacts.add(null, aggregate.getRelPath(), ".xcnd", ArtifactType.PRIMARY, ser, 0L);
        return artifacts;
    }

    @Override
    public ImportInfo remove(Node node, boolean recursive, boolean trySave) throws RepositoryException {
        ImportInfoImpl info = new ImportInfoImpl();
        info.onDeleted(node.getPath());
        Session s = node.getSession();
        node.remove();
        if (trySave) {
            s.save();
        }
        return info;
    }

    @Override
    public void dump(DumpContext ctx, boolean isLast) {
        ctx.println(isLast, this.getClass().getSimpleName());
    }
}

